package com.bxm.newidea.component.sync.core;

import com.bxm.newidea.component.sync.key.SyncCacheKey;

import java.util.function.Function;

/**
 * 提供静态的工具类，直接设定键值和缓存加载方式
 *
 * @author liujia
 * @date 6/16/21 4:17 PM
 **/
public class SyncCacheHolderFactory {
    private SyncCacheHolderFactory() {
    }

    private static CacheHolder cacheHolder;

    static void setCacheHolder(CacheHolder cacheHolder) {
        SyncCacheHolderFactory.cacheHolder = cacheHolder;
    }

    public static CacheHolder getCacheHolder() {
        return cacheHolder;
    }

    public static <T, R> SyncCacheAgent<T, R> build(SyncCacheKey keyGenerator, Function<T, R> cacheLoader) {
        cacheHolder.set(keyGenerator, cacheLoader);
        return new SyncCacheAgent<>(keyGenerator, cacheHolder);
    }
}
