package com.bxm.newidea.component.sync.monitor;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import com.bxm.newidea.component.sync.monitor.param.ClearParam;
import com.bxm.newidea.component.sync.monitor.param.EvictParam;
import com.bxm.newidea.component.vo.ResponseJson;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 二级缓存管理Restful API
 *
 * @author wzy
 * @version 1.0
 * @date 2021/1/7 4:42 下午
 */
@RequestMapping("/second/cache/manage")
@RestController
public class ManageCacheController {

    private final CacheHolder cacheHolder;

    public ManageCacheController(CacheHolder cacheHolder) {
        this.cacheHolder = cacheHolder;
    }

    /**
     * 指定具体某个缓存中的缓存值失效
     */
    @PostMapping("evict")
    public ResponseJson evict(@RequestBody EvictParam evictParam) {
        cacheHolder.evict(SyncCacheKey.build(evictParam.getGroupName(),
                evictParam.getKey()), evictParam.getSubKey());
        return ResponseJson.ok().build();
    }

    /**
     * 清空指定缓存，subKey缓存值
     */
    @PostMapping("clear")
    public ResponseJson clear(@RequestBody ClearParam param) {
        cacheHolder.clear(SyncCacheKey.build(param.getGroupName(), param.getKey()));
        return ResponseJson.ok().build();
    }

    /**
     * 清除分组内的所有缓存信息
     */
    @PostMapping("clearGroup")
    public ResponseJson clearGroup(@RequestBody ClearParam param) {
        cacheHolder.clearGroup(param.getGroupName());
        return ResponseJson.ok().build();
    }

    /**
     * 获取所有二级缓存分组接口
     *
     * @return 二级缓存分组数据
     */
    @GetMapping("allGroup")
    public ResponseJson<List<String>> getAllGroup() {
        return ResponseJson.ok(cacheHolder.getAllGroup());
    }

    /**
     * 获取指定的缓存键值情况
     *
     * @param group  缓存分组
     * @param key    缓存键值
     * @param subKey 具体缓存对象key值
     * @return 缓存结果
     */
    @GetMapping("{group}/{key}/{subKey}")
    public ResponseJson<String> get(@PathVariable String group, @PathVariable String key, @PathVariable String subKey) {
        Object object = cacheHolder.get(SyncCacheKey.build(group, key), subKey);
        if (null == object) {
            return ResponseJson.ok("null");
        }

        return ResponseJson.ok(JSON.toJSONString(object));
    }
}