/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.cluster;

import com.bxm.newidea.component.sync.cluster.Command;
import com.bxm.newidea.component.sync.constants.CommandTypeEnum;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.core.SyncCacheHolderFactory;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(CommandExecutor.class);

    public void executeCommand(Command targetCommand) {
        SyncCacheKey refreshKeyGenerator;
        CacheHolder cacheHolder;
        if (log.isDebugEnabled()) {
            log.debug("\u6267\u884c\u547d\u4ee4\uff1a{}", (Object)targetCommand);
        }
        if ((cacheHolder = SyncCacheHolderFactory.getCacheHolder()).existsCache(refreshKeyGenerator = targetCommand.getKeyGenerator())) {
            if (targetCommand.getOperator() == CommandTypeEnum.OPT_EVICT_KEY.getType()) {
                for (Integer commandKey : targetCommand.getKeys()) {
                    if (!cacheHolder.exists(refreshKeyGenerator, commandKey)) continue;
                    cacheHolder.evict(refreshKeyGenerator, commandKey);
                }
            } else if (targetCommand.getOperator() == CommandTypeEnum.OPT_CLEAR_KEY.getType()) {
                cacheHolder.clear(refreshKeyGenerator);
            }
        }
    }
}

