/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.cluster;

import com.bxm.newidea.component.JSON;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FastOkHttpUtils {
    private static final Logger log = LoggerFactory.getLogger(FastOkHttpUtils.class);
    public static OkHttpClient singleton;

    public static <T> void postJson(String url, T body) throws URISyntaxException, IOException {
        String content = JSON.toJSONString(body);
        URIBuilder uriBuilder = new URIBuilder(url);
        Request request = new Request.Builder().addHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:0.9.4)").url(uriBuilder.toString()).post(RequestBody.create((String)content, (MediaType)MediaType.parse((String)String.valueOf(ContentType.APPLICATION_JSON)))).build();
        singleton.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                log.info("[{}]\u8c03\u7528\u5931\u8d25\uff0c\u9519\u8bef\uff1a{}", (Object)call.request().url(), (Object)e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                if (!response.isSuccessful()) {
                    log.debug("[{}]\u8c03\u7528\u5931\u8d25\uff0c\u54cd\u5e94\u72b6\u6001:{},\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{call.request().url(), response.code(), response.message()});
                }
                response.close();
            }
        });
    }

    private FastOkHttpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(200L, TimeUnit.MILLISECONDS);
        builder.readTimeout(1L, TimeUnit.SECONDS);
        builder.writeTimeout(1L, TimeUnit.SECONDS);
        ConnectionPool connectionPool = new ConnectionPool(5, 30L, TimeUnit.SECONDS);
        builder.connectionPool(connectionPool);
        singleton = builder.build();
    }
}

