/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.cluster.nacos;

import com.alibaba.cloud.nacos.discovery.NacosServiceDiscovery;
import com.alibaba.nacos.api.exception.NacosException;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.sync.cluster.ClusterPolicy;
import com.bxm.newidea.component.sync.cluster.Command;
import com.bxm.newidea.component.sync.cluster.CommandExecutor;
import com.bxm.newidea.component.sync.cluster.FastOkHttpUtils;
import com.bxm.newidea.component.sync.config.MemoryCacheConfigurationProperties;
import com.bxm.newidea.component.sync.constants.BroadcastStrategyEnum;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import com.bxm.newidea.component.tools.IPUtil;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;

public class NacosClusterPolicy
implements ClusterPolicy {
    private static final Logger log = LoggerFactory.getLogger(NacosClusterPolicy.class);
    private MemoryCacheConfigurationProperties properties;
    private NacosServiceDiscovery nacosServiceDiscovery;
    private CommandExecutor commandExecutor;
    private Cache<String, Boolean> unknownServiceCache;

    public NacosClusterPolicy(MemoryCacheConfigurationProperties properties, NacosServiceDiscovery nacosServiceDiscovery, CommandExecutor commandExecutor) {
        this.properties = properties;
        this.nacosServiceDiscovery = nacosServiceDiscovery;
        this.commandExecutor = commandExecutor;
        this.unknownServiceCache = CacheBuilder.newBuilder().maximumSize(300L).expireAfterWrite(3L, TimeUnit.SECONDS).build();
    }

    @Override
    public String name() {
        return "nacos";
    }

    @Override
    public void publish(Command command) {
        if (null == command) {
            return;
        }
        List instances = Lists.newArrayList();
        SyncCacheKey cacheKey = command.getKeyGenerator();
        BroadcastStrategyEnum broadcastStrategy = cacheKey.getBroadcastStrategy();
        try {
            if (BroadcastStrategyEnum.SERVER.equals((Object)broadcastStrategy)) {
                instances = this.nacosServiceDiscovery.getInstances(this.properties.getAppName());
            } else {
                for (String service : this.nacosServiceDiscovery.getServices()) {
                    instances.addAll(this.nacosServiceDiscovery.getInstances(service));
                }
            }
        }
        catch (NacosException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.trigger(command, instances);
    }

    private void trigger(Command command, List<ServiceInstance> instances) {
        String localRealIp = IPUtil.getLocalRealIp();
        for (ServiceInstance instance : instances) {
            if (StringUtils.equals((CharSequence)localRealIp, (CharSequence)instance.getHost()) && Objects.equals(instance.getPort(), this.properties.getServerPort())) {
                this.commandExecutor.executeCommand(command);
                continue;
            }
            this.sendCommand(command, instance);
        }
    }

    private void sendCommand(Command command, ServiceInstance instance) {
        String hostInfo = instance.getHost() + ":" + instance.getPort();
        if (Boolean.TRUE.equals(this.unknownServiceCache.getIfPresent((Object)hostInfo))) {
            if (log.isDebugEnabled()) {
                log.debug("\u670d\u52a1[{}]\u4e0d\u53ef\u7528\u6216\u4e0d\u652f\u6301\uff0c\u4e0d\u53d1\u9001\u547d\u4ee4", (Object)hostInfo);
            }
            return;
        }
        StringBuilder urlBuilder = new StringBuilder("http://");
        urlBuilder.append(hostInfo);
        urlBuilder.append("/expose/nacos/cache");
        if (log.isDebugEnabled()) {
            log.debug("\u5904\u7406\u7f13\u5b58\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)urlBuilder, (Object)JSON.toJSONString((Object)command));
        }
        try {
            FastOkHttpUtils.postJson(urlBuilder.toString(), command);
        }
        catch (Exception e) {
            log.debug("\u670d\u52a1[{}]\u4e0d\u53ef\u7528,\u539f\u56e0\uff1a{}", (Object)hostInfo, (Object)e.getMessage());
            this.unknownServiceCache.put((Object)hostInfo, (Object)Boolean.TRUE);
        }
    }
}

