/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.config;

import com.bxm.newidea.component.sync.cluster.CommandExecutor;
import com.bxm.newidea.component.sync.cluster.springcloudbus.SecondLevelCacheListener;
import com.bxm.newidea.component.sync.cluster.springcloudbus.SpringEventBusClusterPolicy;
import com.bxm.newidea.component.sync.config.MemoryCacheConfigurationProperties;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.cloud.bus.event.UnknownRemoteApplicationEvent;
import org.springframework.cloud.bus.jackson.BusJacksonAutoConfiguration;
import org.springframework.cloud.bus.jackson.SubtypeModule;
import org.springframework.cloud.stream.annotation.StreamMessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeTypeUtils;

@Configuration
@AutoConfigureBefore(value={BusJacksonAutoConfiguration.class})
@ConditionalOnProperty(prefix="second.level.config", name={"eventBroadcast"}, havingValue="springCloudEventBus")
@ConditionalOnBusEnabled
@EnableConfigurationProperties(value={MemoryCacheConfigurationProperties.class})
public class SyncCacheCloudBusAutoConfiguration {
    private MemoryCacheConfigurationProperties properties;

    public SyncCacheCloudBusAutoConfiguration(MemoryCacheConfigurationProperties properties) {
        this.properties = properties;
    }

    @Bean
    public SpringEventBusClusterPolicy springEventBusClusterPolicy() {
        return new SpringEventBusClusterPolicy(this.properties);
    }

    @Bean
    public SecondLevelCacheListener secondLevelCacheListener(CommandExecutor commandExecutor) {
        return new SecondLevelCacheListener(this.properties, commandExecutor);
    }

    @Bean(name={"busJsonConverter"})
    @StreamMessageConverter
    public AbstractMessageConverter busJsonConverter() {
        return new BusJacksonMessageConverter(null);
    }

    class BusJacksonMessageConverter
    extends AbstractMessageConverter
    implements InitializingBean {
        private final Log log;
        private final String DEFAULT_PACKAGE;
        private final ObjectMapper mapper;
        private final boolean mapperCreated;
        private String[] packagesToScan;

        public BusJacksonMessageConverter() {
            this(null);
        }

        @Autowired(required=false)
        public BusJacksonMessageConverter(ObjectMapper objectMapper) {
            super(MimeTypeUtils.APPLICATION_JSON);
            this.log = LogFactory.getLog(BusJacksonMessageConverter.class);
            this.DEFAULT_PACKAGE = ClassUtils.getPackageName(RemoteApplicationEvent.class);
            this.packagesToScan = new String[]{this.DEFAULT_PACKAGE};
            if (objectMapper != null) {
                this.mapper = objectMapper;
                this.mapperCreated = false;
            } else {
                this.mapper = new ObjectMapper();
                this.mapperCreated = true;
            }
        }

        public boolean isMapperCreated() {
            return this.mapperCreated;
        }

        public void setPackagesToScan(String[] packagesToScan) {
            ArrayList<String> packages = new ArrayList<String>(Arrays.asList(packagesToScan));
            if (!packages.contains(this.DEFAULT_PACKAGE)) {
                packages.add(this.DEFAULT_PACKAGE);
            }
            this.packagesToScan = packages.toArray(new String[0]);
        }

        private Class<?>[] findSubTypes() {
            ArrayList types = new ArrayList();
            if (this.packagesToScan != null) {
                for (String pkg : this.packagesToScan) {
                    ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
                    provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(RemoteApplicationEvent.class));
                    Set components = provider.findCandidateComponents(pkg);
                    for (BeanDefinition component : components) {
                        try {
                            types.add(Class.forName(component.getBeanClassName()));
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalStateException("Failed to scan classpath for remote event classes", e);
                        }
                    }
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found sub types: " + types));
            }
            return types.toArray(new Class[0]);
        }

        protected boolean supports(Class<?> aClass) {
            return RemoteApplicationEvent.class.isAssignableFrom(aClass);
        }

        public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
            Object result;
            block7: {
                result = null;
                try {
                    Object payload = message.getPayload();
                    if (payload instanceof byte[]) {
                        try {
                            result = this.mapper.readValue((byte[])payload, targetClass);
                            break block7;
                        }
                        catch (InvalidTypeIdException e) {
                            return new UnknownRemoteApplicationEvent(new Object(), e.getTypeId(), (byte[])payload);
                        }
                    }
                    if (!(payload instanceof String)) break block7;
                    try {
                        result = this.mapper.readValue((String)payload, targetClass);
                    }
                    catch (InvalidTypeIdException e) {
                        return new UnknownRemoteApplicationEvent(new Object(), e.getTypeId(), ((String)payload).getBytes());
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            return result;
        }

        public void afterPropertiesSet() throws Exception {
            this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            this.mapper.registerModule((Module)new SubtypeModule((Class[])this.findSubTypes()));
        }
    }
}

