/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.core;

import com.bxm.newidea.component.sync.cluster.ClusterPolicy;
import com.bxm.newidea.component.sync.config.MemoryCacheConfigurationProperties;
import com.bxm.newidea.component.sync.core.SyncCacheHolderFactory;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import com.bxm.newidea.component.sync.monitor.MonitorCacheVO;
import com.bxm.newidea.component.sync.provider.CacheProvider;
import com.bxm.newidea.component.sync.provider.CacheProviderFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class CacheHolder {
    private CacheProvider cacheProvider;
    private ClusterPolicy clusterPolicy;

    public CacheHolder(MemoryCacheConfigurationProperties properties, ClusterPolicy clusterPolicy) {
        this.cacheProvider = CacheProviderFactory.getProviderInstance(properties.getCacheIndent());
        this.clusterPolicy = clusterPolicy;
        SyncCacheHolderFactory.setCacheHolder(this);
    }

    <T, R> void set(SyncCacheKey keyGenerator, Function<T, R> cacheLoader) {
        this.cacheProvider.set(keyGenerator, cacheLoader);
    }

    public <T, V> Map<T, V> get(SyncCacheKey keyGenerator, Collection<T> subKeys) {
        return this.cacheProvider.get(keyGenerator, subKeys);
    }

    public <T, V> V get(SyncCacheKey keyGenerator, T subKey) {
        return this.cacheProvider.get(keyGenerator, subKey);
    }

    public <T, V> void set(SyncCacheKey keyGenerator, T subKey, V value) {
        this.cacheProvider.set(keyGenerator, subKey, value);
    }

    public <T> boolean exists(SyncCacheKey keyGenerator, T subKey) {
        return this.cacheProvider.exists(keyGenerator, subKey);
    }

    public boolean existsCache(SyncCacheKey keyGenerator) {
        return this.cacheProvider.existsCache(keyGenerator);
    }

    public <T, V> void set(SyncCacheKey keyGenerator, Map<T, V> elements) {
        this.cacheProvider.set(keyGenerator, elements);
    }

    public <T> void evict(SyncCacheKey keyGenerator, T ... subKeys) {
        this.cacheProvider.evict(keyGenerator, subKeys);
    }

    public void clear(SyncCacheKey keyGenerator) {
        this.cacheProvider.clear(keyGenerator);
    }

    public <T> void sendEvictCmd(SyncCacheKey keyGenerator, T ... keys) {
        this.clusterPolicy.sendEvictCmd(keyGenerator, keys);
    }

    public void sendClearCmd(SyncCacheKey keyGenerator) {
        this.clusterPolicy.sendClearCmd(keyGenerator);
    }

    public void clearGroup(String groupName) {
        this.cacheProvider.clearGroup(groupName);
    }

    public List<String> getAllGroup() {
        return this.cacheProvider.getAllGroup();
    }

    public List<MonitorCacheVO> getMonitorInfo() {
        return this.cacheProvider.getMonitorInfo();
    }
}

