/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.key;

import com.bxm.newidea.component.sync.constants.BroadcastStrategyEnum;
import com.bxm.newidea.component.sync.constants.ExpiredStrategyEnum;
import java.util.concurrent.TimeUnit;

public class SyncCacheKey {
    public static final String JOIN_CHAR = ":";
    private String group;
    private String key;
    private long maximumSize;
    private long duration;
    private TimeUnit timeUnit;
    private ExpiredStrategyEnum expiredStrategy;
    private BroadcastStrategyEnum broadcastStrategy;

    private SyncCacheKey(String group, String key) {
        this.group = group;
        this.key = key;
    }

    @Deprecated
    public static SyncCacheKey build(String group, String key) {
        return new SyncCacheKey(group, key);
    }

    public static SyncCacheKeyBuilder builder() {
        return new SyncCacheKeyBuilder();
    }

    public static SyncCacheKeyBuilder builder(String group, String key) {
        return new SyncCacheKeyBuilder(group, key);
    }

    public String gen() {
        return this.group + JOIN_CHAR + this.key;
    }

    public String toString() {
        return this.gen();
    }

    public SyncCacheKey() {
    }

    public String getGroup() {
        return this.group;
    }

    public String getKey() {
        return this.key;
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public ExpiredStrategyEnum getExpiredStrategy() {
        return this.expiredStrategy;
    }

    public BroadcastStrategyEnum getBroadcastStrategy() {
        return this.broadcastStrategy;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setMaximumSize(long maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setExpiredStrategy(ExpiredStrategyEnum expiredStrategy) {
        this.expiredStrategy = expiredStrategy;
    }

    public void setBroadcastStrategy(BroadcastStrategyEnum broadcastStrategy) {
        this.broadcastStrategy = broadcastStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SyncCacheKey)) {
            return false;
        }
        SyncCacheKey other = (SyncCacheKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaximumSize() != other.getMaximumSize()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        if (this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit)) {
            return false;
        }
        ExpiredStrategyEnum this$expiredStrategy = this.getExpiredStrategy();
        ExpiredStrategyEnum other$expiredStrategy = other.getExpiredStrategy();
        if (this$expiredStrategy == null ? other$expiredStrategy != null : !((Object)((Object)this$expiredStrategy)).equals((Object)other$expiredStrategy)) {
            return false;
        }
        BroadcastStrategyEnum this$broadcastStrategy = this.getBroadcastStrategy();
        BroadcastStrategyEnum other$broadcastStrategy = other.getBroadcastStrategy();
        return !(this$broadcastStrategy == null ? other$broadcastStrategy != null : !((Object)((Object)this$broadcastStrategy)).equals((Object)other$broadcastStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SyncCacheKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maximumSize = this.getMaximumSize();
        result = result * 59 + (int)($maximumSize >>> 32 ^ $maximumSize);
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        ExpiredStrategyEnum $expiredStrategy = this.getExpiredStrategy();
        result = result * 59 + ($expiredStrategy == null ? 43 : ((Object)((Object)$expiredStrategy)).hashCode());
        BroadcastStrategyEnum $broadcastStrategy = this.getBroadcastStrategy();
        result = result * 59 + ($broadcastStrategy == null ? 43 : ((Object)((Object)$broadcastStrategy)).hashCode());
        return result;
    }

    public static class SyncCacheKeyBuilder {
        private String group;
        private String key;
        private long maximumSize = 1000L;
        private long duration = 60L;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private ExpiredStrategyEnum expiredStrategy = ExpiredStrategyEnum.AFTER_WRITE;
        private BroadcastStrategyEnum broadcastStrategy = BroadcastStrategyEnum.SERVER;

        SyncCacheKeyBuilder() {
        }

        SyncCacheKeyBuilder(String group, String key) {
            this.group = group;
            this.key = key;
        }

        public SyncCacheKeyBuilder maximumSize(long maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        public SyncCacheKeyBuilder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public SyncCacheKeyBuilder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public SyncCacheKeyBuilder expiredAfterWrite() {
            this.expiredStrategy = ExpiredStrategyEnum.AFTER_WRITE;
            return this;
        }

        public SyncCacheKeyBuilder expiredAfterRead() {
            this.expiredStrategy = ExpiredStrategyEnum.AFTER_READ;
            return this;
        }

        public SyncCacheKeyBuilder broadcastStrategy(BroadcastStrategyEnum broadcastStrategy) {
            this.broadcastStrategy = broadcastStrategy;
            return this;
        }

        public SyncCacheKey build() {
            if (this.group == null || this.key == null) {
                throw new IllegalArgumentException("group\u6216key\u5fc5\u987b\u5b9a\u4e49");
            }
            SyncCacheKey key = new SyncCacheKey();
            key.group = this.group;
            key.key = this.key;
            key.maximumSize = this.maximumSize;
            key.duration = this.duration;
            key.timeUnit = this.timeUnit;
            key.expiredStrategy = this.expiredStrategy;
            key.broadcastStrategy = this.broadcastStrategy;
            return key;
        }
    }
}

