package com.bxm.newidea.component.sync.core;

import com.bxm.newidea.component.sync.key.SyncCacheKey;
import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;

/**
 * CacheHolder建造者
 *
 * @author liujia
 * @date 6/16/21 4:25 PM
 **/
@Slf4j
public class CacheHolderBuilder {

    /**
     * 全局缓存键值，表明一组特殊的缓存数据
     */
    private SyncCacheKey keyGenerator;

    /**
     * 缓存数据如何加载
     */
    private Function cacheLoader;

    /**
     * 当前缓存最多缓存多少个对象
     */
    private long maximumSize = 1000;

    /**
     * 缓存写入后多久时间后过期
     */
    private long duration = 60;

    /**
     * 过期时间的单位
     */
    private TimeUnit timeUnit = TimeUnit.SECONDS;

    /**
     * 缓存操作持有类
     */
    private CacheHolder cacheHolder;

    CacheHolderBuilder(CacheHolder cacheHolder) {
        this.cacheHolder = cacheHolder;
    }

    public CacheHolderBuilder keyGenerator(SyncCacheKey keyGenerator) {
        this.keyGenerator = keyGenerator;
        return this;
    }

    public <T, R> CacheHolderBuilder cacheLoader(Function<T, R> cacheLoader) {
        this.cacheLoader = cacheLoader;
        return this;
    }

    public CacheHolderBuilder maximumSize(long maximumSize) {
        this.maximumSize = maximumSize;
        return this;
    }

    public CacheHolderBuilder duration(long duration) {
        this.duration = duration;
        return this;
    }

    public CacheHolderBuilder timeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    public CacheHolder build() {
        if (null == keyGenerator) {
            log.error("缓存键值必须指定");
        }

        if (cacheLoader == null) {
            log.info("[{}]未指定缓存数据加载来源", keyGenerator);
        }

        cacheHolder.set(keyGenerator, cacheLoader, maximumSize, timeUnit, duration);
        return cacheHolder;
    }
}
