package com.bxm.newidea.component.sync.core;

import com.bxm.newidea.component.sync.key.SyncCacheKey;

import java.util.function.Function;

/**
 * 同步缓存的工厂类，明确调用参数和过程
 *
 * @author liujia
 * @date 6/16/21 4:17 PM
 **/
public class SyncCacheHolderFactory {
    private SyncCacheHolderFactory() {
    }

    private static CacheHolder cacheHolder;

    static void setCacheHolder(CacheHolder cacheHolder) {
        SyncCacheHolderFactory.cacheHolder = cacheHolder;
    }

    public static <T, R> CacheHolder build(SyncCacheKey keyGenerator, Function<T, R> cacheLoader) {
        cacheHolder.set(keyGenerator, cacheLoader);
        return cacheHolder;
    }

    public static CacheHolderBuilder builder() {
        return new CacheHolderBuilder(cacheHolder);
    }
}
