/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.cluster.springcloudbus;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.sync.cluster.ClusterPolicy;
import com.bxm.newidea.component.sync.cluster.Command;
import com.bxm.newidea.component.sync.cluster.FastOkHttpUtils;
import com.bxm.newidea.component.sync.config.MemoryCacheConfigurationProperties;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class SpringEventBusClusterPolicy
implements ClusterPolicy {
    private static final Logger log = LoggerFactory.getLogger(SpringEventBusClusterPolicy.class);
    private final MemoryCacheConfigurationProperties memoryCacheConfigurationProperties;
    private static final String EMPTY_STRING = "";
    private static final String PATH_SEPARATOR = "/";
    @Value(value="${server.servlet.context-path:/}")
    private String contextPath;

    public SpringEventBusClusterPolicy(MemoryCacheConfigurationProperties memoryCacheConfigurationProperties) {
        this.memoryCacheConfigurationProperties = memoryCacheConfigurationProperties;
    }

    @Override
    public String name() {
        return "springCloudEventBus";
    }

    @Override
    public void publish(Command command) {
        String envUrl = this.getEnvUrl();
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("name", this.memoryCacheConfigurationProperties.getEnvName());
        params.put("value", JSON.toJSONString((Object)command));
        FastOkHttpUtils.postJson(envUrl, params);
    }

    private String getEnvUrl() {
        String envUrl = this.memoryCacheConfigurationProperties.getEnvTemplateUrl();
        String finalPort = String.valueOf(this.memoryCacheConfigurationProperties.getServerPort());
        String finalContextPath = this.contextPath;
        if (StringUtils.isBlank((CharSequence)finalContextPath)) {
            finalContextPath = EMPTY_STRING;
        } else {
            if (!finalContextPath.startsWith(PATH_SEPARATOR)) {
                finalContextPath = PATH_SEPARATOR + finalContextPath;
            }
            if (finalContextPath.endsWith(PATH_SEPARATOR)) {
                finalContextPath = finalContextPath.substring(0, finalContextPath.length() - 1);
            }
        }
        return String.format(envUrl, finalPort, finalContextPath);
    }
}

