/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.config;

import com.bxm.newidea.component.sync.cluster.ClusterPolicy;
import com.bxm.newidea.component.sync.cluster.CommandExecutor;
import com.bxm.newidea.component.sync.cluster.DefaultClusterPolicy;
import com.bxm.newidea.component.sync.config.MemoryCacheConfigurationProperties;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.monitor.SyncCacheMeterBinder;
import com.bxm.newidea.component.tools.StringUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MemoryCacheConfigurationProperties.class})
public class CacheSyncAutoConfiguration
implements MeterBinder {
    private static final Logger log = LoggerFactory.getLogger(CacheSyncAutoConfiguration.class);
    private MemoryCacheConfigurationProperties properties;
    private MeterRegistry registry;

    public CacheSyncAutoConfiguration(MemoryCacheConfigurationProperties properties) {
        this.properties = properties;
    }

    @Bean
    public CacheHolder cacheHolder(List<ClusterPolicy> clusterPolicies, SyncCacheMeterBinder binder) {
        ClusterPolicy matchClusterPolicy = new DefaultClusterPolicy();
        for (ClusterPolicy clusterPolicy : clusterPolicies) {
            if (!StringUtils.equals((CharSequence)clusterPolicy.name(), (CharSequence)this.properties.getEventBroadcast())) continue;
            matchClusterPolicy = clusterPolicy;
            break;
        }
        log.info("[c-cache] \u7f13\u5b58\u7684\u5e7f\u64ad\u7b56\u7565\u4e3a\uff1a{}", (Object)matchClusterPolicy);
        return new CacheHolder(this.properties, matchClusterPolicy, binder);
    }

    @Bean
    public SyncCacheMeterBinder syncCacheMeterBinder() {
        return new SyncCacheMeterBinder();
    }

    @Bean
    public CommandExecutor commandExecutor() {
        return new CommandExecutor();
    }

    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
    }
}

