/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.config;

import com.alibaba.cloud.nacos.discovery.NacosServiceDiscovery;
import com.bxm.newidea.component.sync.cluster.Command;
import com.bxm.newidea.component.sync.cluster.CommandExecutor;
import com.bxm.newidea.component.sync.cluster.nacos.NacosClusterPolicy;
import com.bxm.newidea.component.sync.config.MemoryCacheConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Configuration
@EnableConfigurationProperties(value={MemoryCacheConfigurationProperties.class})
@ConditionalOnProperty(prefix="second.level.config", name={"eventBroadcast"}, havingValue="nacos", matchIfMissing=true)
@ConditionalOnClass(value={NacosServiceDiscovery.class})
@ConditionalOnBean(value={NacosServiceDiscovery.class})
public class SyncCacheNacosAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SyncCacheNacosAutoConfiguration.class);
    private MemoryCacheConfigurationProperties properties;

    public SyncCacheNacosAutoConfiguration(MemoryCacheConfigurationProperties properties) {
        this.properties = properties;
    }

    @Bean
    public NacosClusterPolicy nacosClusterPolicy(NacosServiceDiscovery nacosServiceDiscovery, CommandExecutor commandExecutor) {
        return new NacosClusterPolicy(this.properties, nacosServiceDiscovery, commandExecutor);
    }

    @RestController
    @RequestMapping(value={"/expose/nacos/cache"})
    public class NacosClusterPolicyExpose {
        private CommandExecutor commandExecutor;

        @PostMapping(value={"command"})
        public Boolean command(@RequestBody Command command) {
            if (log.isDebugEnabled()) {
                log.debug("\u6267\u884cnacos\u8fdc\u7a0b\u547d\u4ee4\uff1a{}", (Object)command);
            }
            this.commandExecutor.executeCommand(command);
            return true;
        }

        public NacosClusterPolicyExpose(CommandExecutor commandExecutor) {
            this.commandExecutor = commandExecutor;
        }
    }
}

