/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.core;

import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import com.bxm.newidea.component.sync.monitor.SyncCacheMeterBinder;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public abstract class AbstractSyncCacheProvider<KEY, DATA>
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(AbstractSyncCacheProvider.class);
    @Resource
    private CacheHolder cacheHolder;
    @Resource
    private SyncCacheMeterBinder meterBinder;
    private final ThreadLocal<KEY> threadLocal = new ThreadLocal();

    public void run(ApplicationArguments args) {
        if (null == this.key()) {
            throw new IllegalArgumentException("[c-cache] #key()\u65b9\u6cd5\u5fc5\u987b\u8fd4\u56de\u503c");
        }
        this.cacheHolder.set(this.key(), s -> {
            KEY key = this.threadLocal.get();
            if (key == null) {
                return this.loadByEncodeKey((String)s);
            }
            return this.load(key);
        });
        this.meterBinder.bind(this.key());
        log.info("[c-cache] \u521d\u59cb\u5316\u5185\u5b58\u7f13\u5b58\uff0cgroup\u4e3a\uff1a{}", (Object)this.key());
    }

    private DATA loadByEncodeKey(String encodeKey) {
        log.warn("[c-cache] \u83b7\u53d6\u4e8c\u7ea7\u7f13\u5b58\u65f6\uff0ckey\u662f\u7a7a\u503c\uff0c\u8bf7\u6c42\u7684key\u4e3a\uff1a{}", (Object)encodeKey);
        return null;
    }

    protected abstract DATA load(KEY var1);

    protected abstract SyncCacheKey key();

    protected abstract String toKeyString(KEY var1);

    public void put(KEY subKey, DATA data) {
        this.cacheHolder.set(this.key(), this.toKeyString(subKey), data);
    }

    public DATA get(KEY subKey) {
        if (null == subKey) {
            log.debug("[c-cache] \u67e5\u8be2\u4e8c\u7ea7\u7f13\u5b58\u9700\u8981\u907f\u514d\u4f20\u9012null\u4f5c\u4e3asubKey");
            return null;
        }
        String keyString = this.toKeyString(subKey);
        if (StringUtils.isBlank((CharSequence)keyString)) {
            log.warn("[c-cache] {}\u901a\u8fc7toKeyString\u89e3\u6790\u540e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5b9e\u73b0\u4e86toKeyString\u65b9\u6cd5", subKey);
            return null;
        }
        this.threadLocal.set(subKey);
        Object data = this.cacheHolder.get(this.key(), keyString);
        this.threadLocal.remove();
        return (DATA)data;
    }

    public Collection<DATA> getAll() {
        ConcurrentMap allMap = this.cacheHolder.getAllMap(this.key());
        if (null != allMap) {
            return allMap.values();
        }
        return Lists.newArrayList();
    }

    public void remove(KEY subKey) {
        String decodeSubKey = this.toKeyString(subKey);
        this.cacheHolder.evict(this.key(), decodeSubKey);
        this.cacheHolder.sendEvictCmd(this.key(), decodeSubKey);
    }

    public void removeAll() {
        this.cacheHolder.clear(this.key());
        this.cacheHolder.sendClearCmd(this.key());
        log.info("[c-cache] {}\u6e05\u7406\u5168\u90e8\u7f13\u5b58", (Object)this.key());
    }
}

