/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.core;

import com.bxm.newidea.component.sync.cluster.ClusterPolicy;
import com.bxm.newidea.component.sync.config.MemoryCacheConfigurationProperties;
import com.bxm.newidea.component.sync.core.SyncCacheHolderFactory;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import com.bxm.newidea.component.sync.monitor.CacheStatusBO;
import com.bxm.newidea.component.sync.monitor.SyncCacheMeterBinder;
import com.bxm.newidea.component.sync.provider.CacheProvider;
import com.bxm.newidea.component.sync.provider.CacheProviderFactory;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class CacheHolder {
    private final CacheProvider cacheProvider;
    private final ClusterPolicy clusterPolicy;

    public CacheHolder(MemoryCacheConfigurationProperties properties, ClusterPolicy clusterPolicy, SyncCacheMeterBinder binder) {
        this.cacheProvider = CacheProviderFactory.getProviderInstance(properties.getCacheIndent());
        this.clusterPolicy = clusterPolicy;
        binder.setCacheHolder(this);
        SyncCacheHolderFactory.setCacheHolder(this);
        SyncCacheHolderFactory.setMeterBinder(binder);
    }

    <T, R> void set(SyncCacheKey keyGenerator, Function<String, R> cacheLoader) {
        this.cacheProvider.set(keyGenerator, cacheLoader);
    }

    public <V> Map<String, V> get(SyncCacheKey keyGenerator, Collection<String> subKeys) {
        return this.cacheProvider.get(keyGenerator, subKeys);
    }

    public <V> V get(SyncCacheKey keyGenerator, String subKey) {
        return this.cacheProvider.get(keyGenerator, subKey);
    }

    public <V> void set(SyncCacheKey keyGenerator, String subKey, V value) {
        this.cacheProvider.set(keyGenerator, subKey, value);
    }

    public boolean exists(SyncCacheKey keyGenerator, String subKey) {
        return this.cacheProvider.exists(keyGenerator, subKey);
    }

    public boolean existsCache(SyncCacheKey keyGenerator) {
        return this.cacheProvider.existsCache(keyGenerator);
    }

    public <V> void set(SyncCacheKey keyGenerator, Map<String, V> elements) {
        this.cacheProvider.set(keyGenerator, elements);
    }

    public void evict(SyncCacheKey keyGenerator, String ... subKeys) {
        this.cacheProvider.evict(keyGenerator, subKeys);
    }

    public void clear(SyncCacheKey keyGenerator) {
        this.cacheProvider.clear(keyGenerator);
    }

    public void sendEvictCmd(SyncCacheKey keyGenerator, String ... keys) {
        this.clusterPolicy.sendEvictCmd(keyGenerator, Lists.newArrayList((Object[])keys));
    }

    public void sendClearCmd(SyncCacheKey keyGenerator) {
        this.clusterPolicy.sendClearCmd(keyGenerator);
    }

    public void clearGroup(String groupName) {
        this.cacheProvider.clearGroup(groupName);
    }

    public List<String> getAllGroup() {
        return this.cacheProvider.getAllGroup();
    }

    public List<CacheStatusBO> getMonitorInfo() {
        return this.cacheProvider.getMonitorInfo();
    }

    public CacheStatusBO getMonitorInfo(SyncCacheKey cacheKey) {
        return this.cacheProvider.getMonitor(cacheKey);
    }

    public CacheStatusBO getMonitorInfoWithKey(SyncCacheKey cacheKey) {
        List<CacheStatusBO> monitorInfoList = this.cacheProvider.getMonitorInfo();
        for (CacheStatusBO cacheStatusBO : monitorInfoList) {
            if (!Objects.equals(cacheStatusBO.getCacheName(), cacheKey.gen())) continue;
            return cacheStatusBO;
        }
        return null;
    }

    public <V> ConcurrentMap<String, V> getAllMap(SyncCacheKey keyGenerator) {
        return this.cacheProvider.getAllMap(keyGenerator);
    }
}

