/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.core;

import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.key.SyncCacheKey;

public class SyncCacheAgent<T, R> {
    private final CacheHolder cacheHolder;
    private final SyncCacheKey cacheKey;
    private final ThreadLocal<T> threadLocal;

    SyncCacheAgent(SyncCacheKey cacheKey, CacheHolder cacheHolder, ThreadLocal<T> threadLocal) {
        this.cacheKey = cacheKey;
        this.cacheHolder = cacheHolder;
        this.threadLocal = threadLocal;
    }

    public void put(T subKey, R data) {
        this.cacheHolder.set(this.cacheKey, this.toHashString(subKey), data);
    }

    private String toHashString(T subKey) {
        return String.valueOf(subKey.hashCode());
    }

    public R get(T subKey) {
        Object data;
        this.threadLocal.set(subKey);
        try {
            data = this.cacheHolder.get(this.cacheKey, this.toHashString(subKey));
        }
        finally {
            this.threadLocal.remove();
        }
        return (R)data;
    }

    public void sendEvictCmd(T ... keys) {
        String[] subKeys = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            subKeys[i] = this.toHashString(keys[i]);
        }
        this.cacheHolder.sendEvictCmd(this.cacheKey, subKeys);
    }

    public void sendClearCmd() {
        this.cacheHolder.sendClearCmd(this.cacheKey);
    }

    public void clearCurrentGroup() {
        this.cacheHolder.clearGroup(this.cacheKey.getGroup());
    }

    public CacheHolder getCacheHolder() {
        return this.cacheHolder;
    }
}

