/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.expose.controller;

import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.sync.expose.dto.CacheSubDataDTO;
import com.bxm.newidea.component.sync.expose.param.CacheFetchParam;
import com.bxm.newidea.component.sync.expose.param.CacheRemoveParam;
import com.bxm.newidea.component.sync.expose.service.ExposeSyncCacheService;
import com.bxm.newidea.component.sync.monitor.CacheStatusBO;
import com.bxm.newidea.component.vo.ResponseJson;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/expose/sync-cache"})
public class SyncCacheExposeController {
    private static final Logger log = LoggerFactory.getLogger(SyncCacheExposeController.class);
    private final ExposeSyncCacheService exposeSyncCacheService;

    @GetMapping(value={"fetch/key"})
    public ResponseJson<List<CacheStatusBO>> fetchKeyList() {
        return ResponseJson.ok(this.exposeSyncCacheService.fetchKey());
    }

    @GetMapping(value={"fetch/data"})
    public ResponseJson<List<CacheSubDataDTO>> fetchData(CacheFetchParam param) {
        return ResponseJson.ok(this.exposeSyncCacheService.fetchSubKey(param));
    }

    @PostMapping(value={"clean"})
    public ResponseJson<?> clean(@RequestBody CacheRemoveParam param) {
        return ResponseJson.build((Message)this.exposeSyncCacheService.clean(param));
    }

    public SyncCacheExposeController(ExposeSyncCacheService exposeSyncCacheService) {
        this.exposeSyncCacheService = exposeSyncCacheService;
    }
}

