/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.expose.service;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.expose.dto.CacheSubDataDTO;
import com.bxm.newidea.component.sync.expose.param.CacheFetchParam;
import com.bxm.newidea.component.sync.expose.param.CacheRemoveParam;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import com.bxm.newidea.component.sync.monitor.CacheStatusBO;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExposeSyncCacheService {
    private static final Logger log = LoggerFactory.getLogger(ExposeSyncCacheService.class);
    public static final long MAX_CACHE_DATA = 20000L;
    private CacheHolder cacheHolder;

    public List<CacheStatusBO> fetchKey() {
        return this.cacheHolder.getMonitorInfo();
    }

    public List<CacheSubDataDTO> fetchSubKey(CacheFetchParam param) {
        ArrayList cacheResultData = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)param.getCacheKey())) {
            return cacheResultData;
        }
        SyncCacheKey queryKey = SyncCacheKey.builder(param.getCacheKey(), null).build();
        if (StringUtils.isNotBlank((CharSequence)param.getSubKey())) {
            Object data = this.cacheHolder.get(queryKey, param.getSubKey());
            CacheSubDataDTO cacheSubDataDTO = new CacheSubDataDTO();
            cacheSubDataDTO.setKey(param.getCacheKey());
            cacheSubDataDTO.setSubKey(param.getSubKey());
            cacheSubDataDTO.setData(JSON.toJSONString(data));
            cacheResultData.add(cacheSubDataDTO);
            return cacheResultData;
        }
        CacheStatusBO monitor = this.cacheHolder.getMonitorInfo(queryKey);
        if (monitor.getSize() > 20000L) {
            return cacheResultData;
        }
        ConcurrentMap allMap = this.cacheHolder.getAllMap(queryKey);
        int limit = 20;
        for (Map.Entry entry : allMap.entrySet()) {
            if (limit <= 0) break;
            CacheSubDataDTO cacheSubDataDTO = new CacheSubDataDTO();
            cacheSubDataDTO.setKey(param.getCacheKey());
            cacheSubDataDTO.setSubKey((String)entry.getKey());
            cacheSubDataDTO.setData(JSON.toJSONString(entry.getValue()));
            cacheResultData.add(cacheSubDataDTO);
            --limit;
        }
        return cacheResultData;
    }

    public Message clean(CacheRemoveParam param) {
        SyncCacheKey removeKey = SyncCacheKey.builder(param.getCacheKey(), param.getSubKey()).build();
        if (param.getSubKey() != null && param.getCacheKey() != null) {
            log.info("[sync-cache]\u6e05\u7406\u7f13\u5b58\uff0ckey:{},subKey:{}", (Object)param.getCacheKey(), (Object)param.getSubKey());
            this.cacheHolder.evict(removeKey, param.getSubKey());
        } else {
            log.info("[sync-cache]\u6e05\u7406\u7f13\u5b58\u5206\u7ec4\uff0ckey:{}", (Object)param.getCacheKey());
            this.cacheHolder.clear(removeKey);
        }
        return Message.build();
    }

    public ExposeSyncCacheService(CacheHolder cacheHolder) {
        this.cacheHolder = cacheHolder;
    }
}

