/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.demo;

import com.bxm.demo.MockBean;
import com.bxm.newidea.component.sync.constants.BroadcastStrategyEnum;
import com.bxm.newidea.component.sync.core.SyncCacheAgent;
import com.bxm.newidea.component.sync.core.SyncCacheHolderFactory;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import com.bxm.newidea.component.tools.RandomUtils;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class RefreshCacheDemo
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(RefreshCacheDemo.class);
    private static final SyncCacheKey KEY = SyncCacheKey.builder((String)"group", (String)"hizz").maximumSize(1000L).timeUnit(TimeUnit.MINUTES).duration(1L).expiredAfterWrite().broadcastStrategy(BroadcastStrategyEnum.SPECIAL_SERVER).serverName(new String[]{"egg-user", "test1", "egg-config", "egg-user"}).build();

    public void randomCache() {
        SyncCacheAgent cacheAgent = SyncCacheHolderFactory.build((SyncCacheKey)KEY, i -> {
            MockBean bean = new MockBean();
            bean.setId((Long)i);
            bean.setName(i + "i");
            return bean;
        });
        MockBean value = (MockBean)((Object)cacheAgent.get((Object)RandomUtils.nextLong((long)0L, (long)100000L)));
        if (value.getId() % 5L == 0L) {
            cacheAgent.sendClearCmd();
        } else if (value.getId() % 3L == 0L) {
            cacheAgent.sendEvictCmd((Object[])new MockBean[]{value});
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(this::randomCache, 0L, 3L, TimeUnit.SECONDS);
    }
}

