/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UrlUtils {
    private static final Pattern URL_PATTERN = Pattern.compile("^((https|http|ftp|rtsp|mms)?://)?(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6})(:[0-9]{1,5})?((/?)|(/[0-9a-z_!~*'().;?:@&=+$,%#-]+)+/?)$");

    public static Optional<String> eliminateHost(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return Optional.empty();
        }
        String[] subUrls = url.split("\\/\\/");
        if (subUrls.length < 2) {
            return Optional.empty();
        }
        int index = subUrls[1].indexOf("/");
        if (index == -1) {
            return Optional.empty();
        }
        return Optional.of(subUrls[1].substring(index));
    }

    private static Optional<UriInfo> parse(String uri) {
        if (!URL_PATTERN.matcher(uri).matches()) {
            return Optional.empty();
        }
        UriInfo info = new UriInfo();
        String[] hostAndOther = uri.split(":");
        if (hostAndOther.length < 2) {
            return Optional.empty();
        }
        info.setHost(hostAndOther[0]);
        String other = hostAndOther[1].substring(2);
        int index = other.indexOf("/");
        if (index == -1) {
            info.setHost(other);
            return Optional.of(info);
        }
        String host = other.substring(0, index);
        info.setHost(host);
        if (index == uri.length() - 1) {
            other = other.substring(index);
        }
        return Optional.empty();
    }

    public static class UriInfo {
        private String protocol;
        private String host;
        private int port;
        private String path;
        private String route;
        private Map<String, List<String>> params;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.protocol);
            sb.append("://");
            sb.append(this.host);
            if (this.port != 0) {
                sb.append(this.port);
            }
            sb.append(this.path);
            sb.append("#");
            sb.append(this.route);
            if (Objects.nonNull(this.params) && !this.params.isEmpty()) {
                sb.append("?");
                this.params.forEach((k, value) -> value.forEach(v1 -> {
                    sb.append((String)k);
                    sb.append("=");
                    sb.append((String)v1);
                    sb.append("&");
                }));
            }
            return sb.toString();
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getPath() {
            return this.path;
        }

        public String getRoute() {
            return this.route;
        }

        public Map<String, List<String>> getParams() {
            return this.params;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setRoute(String route) {
            this.route = route;
        }

        public void setParams(Map<String, List<String>> params) {
            this.params = params;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UriInfo)) {
                return false;
            }
            UriInfo other = (UriInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$protocol = this.getProtocol();
            String other$protocol = other.getProtocol();
            if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$route = this.getRoute();
            String other$route = other.getRoute();
            if (this$route == null ? other$route != null : !this$route.equals(other$route)) {
                return false;
            }
            Map<String, List<String>> this$params = this.getParams();
            Map<String, List<String>> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UriInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            result = result * 59 + this.getPort();
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $route = this.getRoute();
            result = result * 59 + ($route == null ? 43 : $route.hashCode());
            Map<String, List<String>> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }
    }
}

