/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import com.bxm.newidea.component.tools.StringUtils;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final Map<Class<?>, Class<?>> CLASS_MAP = new HashMap();

    private ReflectionUtils() {
    }

    public static boolean isNumeric(Class<?> clasz) {
        return Integer.TYPE.isAssignableFrom(clasz) || Integer.class.isAssignableFrom(clasz) || Float.TYPE.isAssignableFrom(clasz) || Double.TYPE.isAssignableFrom(clasz) || Double.class.isAssignableFrom(clasz) || Float.class.isAssignableFrom(clasz) || Long.TYPE.isAssignableFrom(clasz) || Long.class.isAssignableFrom(clasz) || Short.TYPE.isAssignableFrom(clasz) || Short.class.isAssignableFrom(clasz) || Byte.TYPE.isAssignableFrom(clasz) || Byte.class.isAssignableFrom(clasz);
    }

    public static boolean isNumeric(Object obj) {
        if (null == obj) {
            return false;
        }
        Class<?> clasz = obj.getClass();
        return Integer.TYPE.isAssignableFrom(clasz) || Integer.class.isAssignableFrom(clasz) || Float.TYPE.isAssignableFrom(clasz) || Float.class.isAssignableFrom(clasz) || Long.TYPE.isAssignableFrom(clasz) || Long.class.isAssignableFrom(clasz) || Short.TYPE.isAssignableFrom(clasz) || Short.class.isAssignableFrom(clasz) || Byte.TYPE.isAssignableFrom(clasz) || Byte.class.isAssignableFrom(clasz);
    }

    public static boolean isPrimitiveType(Class<?> clasz) {
        return ReflectionUtils.isNumeric(clasz) || Character.TYPE.isAssignableFrom(clasz) || CharSequence.class.isAssignableFrom(clasz) || String.class.isAssignableFrom(clasz) || Boolean.TYPE.isAssignableFrom(clasz) || Boolean.class.isAssignableFrom(clasz);
    }

    public static boolean isSimpleType(Field field) {
        boolean result = false;
        Class<?> fieldClasz = field.getType();
        if (fieldClasz.isPrimitive()) {
            result = true;
        } else if (ReflectionUtils.isWarper(fieldClasz)) {
            result = true;
        } else if (String.class.isAssignableFrom(fieldClasz) || Date.class.isAssignableFrom(fieldClasz) || Date.class.isAssignableFrom(fieldClasz)) {
            result = true;
        }
        return result;
    }

    public static boolean isWarper(Class<?> clasz) {
        if (clasz == null) {
            return false;
        }
        try {
            Field[] fields;
            for (Field field : fields = clasz.getDeclaredFields()) {
                if (!"TYPE".equals(field.getName())) continue;
                return ((Class)field.get(null)).isPrimitive();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean isJavaClass(Class<?> clasz) {
        return clasz != null && clasz.getClassLoader() == null;
    }

    public static Class wrapperClassToBaseClass(Object wrapperClassObject) {
        Class<?> wrapperClass = wrapperClassObject.getClass();
        return ReflectionUtils.wrapperClassToBaseClass(wrapperClass);
    }

    public static Class wrapperClassToBaseClass(Class wrapperClass) {
        Class baseClass = CLASS_MAP.get(wrapperClass);
        if (null == baseClass) {
            baseClass = wrapperClass;
        }
        return baseClass;
    }

    public static String getFieldName(String methodName) {
        String fieldName;
        if (StringUtils.startsWith((CharSequence)methodName, (CharSequence)"get")) {
            fieldName = StringUtils.replaceFirst((String)methodName, (String)"get", (String)"");
        } else if (StringUtils.startsWith((CharSequence)methodName, (CharSequence)"is")) {
            fieldName = StringUtils.replaceFirst((String)methodName, (String)"is", (String)"");
        } else {
            return null;
        }
        return StringUtils.lowerCaseFirstChar(fieldName);
    }

    static {
        CLASS_MAP.put(Integer.class, Integer.TYPE);
        CLASS_MAP.put(Character.class, Character.TYPE);
        CLASS_MAP.put(Long.class, Long.TYPE);
        CLASS_MAP.put(Float.class, Float.TYPE);
        CLASS_MAP.put(Double.class, Double.TYPE);
        CLASS_MAP.put(Byte.class, Byte.TYPE);
        CLASS_MAP.put(Short.class, Short.TYPE);
        CLASS_MAP.put(Boolean.class, Boolean.TYPE);
    }
}

