package com.bxm.newidea.component.tools;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CronUtil {
    private CronUtil() {
    }

    private static ThreadLocal<DateFormat> dateFormatThreadLocal = ThreadLocal.withInitial(() -> new SimpleDateFormat("ss mm HH dd MM ?"));

    /**
     * 根据启动时间获取cron表达式（只执行一次）
     *
     * @param date 启动时间
     * @return cron表达式
     */
    public static String formatDateToCron(Date date) {
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = dateFormatThreadLocal.get().format(date);
        }
        return formatTimeStr;
    }

}
