/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import cn.hutool.core.date.SystemClock;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.time.DateFormatUtils;

public final class DateBeautifyUtils {
    private static final String ONE_SECOND_AGO = "\u51e0\u79d2\u524d";
    private static final String ONE_MINUTE_AGO = "\u5206\u949f\u524d";
    private static final String ONE_HOUR_AGO = "\u5c0f\u65f6\u524d";
    private static final String YESTERDAY = "\u6628\u5929";
    private static final String ONE_DAY_AGO = "\u5929\u524d";
    private static final String ONE_WEEK_AGO = "\u5468\u524d";
    private static final String ONE_MONTH_AGO = "\u6708\u524d";
    private static final String ONE_YEAR_AGO = "\u5e74\u524d";

    public static String timeConvertString(Date date) {
        if (Objects.isNull(date)) {
            date = new Date();
        }
        long coverTimeMillis = date.getTime();
        Calendar instance = Calendar.getInstance();
        Calendar yesterday = DateBeautifyUtils.getMorningTime(-1);
        long yesterdayTimeInMillis = yesterday.getTimeInMillis();
        Calendar beforeYesterday = DateBeautifyUtils.getMorningTime(-2);
        long currentTimeMillis = instance.getTimeInMillis();
        long differenceTime = currentTimeMillis - coverTimeMillis;
        String result = differenceTime <= 60000L ? "\u521a\u521a" : (differenceTime > 60000L && differenceTime <= 3600000L ? differenceTime / 60000L + ONE_MINUTE_AGO : (differenceTime > 3600000L && differenceTime < 86400000L ? differenceTime / 3600000L + ONE_HOUR_AGO : (differenceTime >= 86400000L && differenceTime <= currentTimeMillis - yesterdayTimeInMillis ? YESTERDAY + DateFormatUtils.format((Date)date, (String)"HH:mm") : (differenceTime > currentTimeMillis - yesterdayTimeInMillis && differenceTime <= currentTimeMillis - beforeYesterday.getTimeInMillis() ? "\u524d\u5929" + DateFormatUtils.format((Date)date, (String)"HH:mm") : DateFormatUtils.format((Date)date, (String)"yyyy/MM/dd")))));
        return result;
    }

    public static String getTimeLag(Date date) {
        if (null == date) {
            return null;
        }
        long delta = SystemClock.now() - date.getTime();
        if (delta < 60000L) {
            return ONE_SECOND_AGO;
        }
        if (delta < 3600000L) {
            long minutes = delta / 60000L;
            return minutes + ONE_MINUTE_AGO;
        }
        if (delta < 86400000L) {
            long hours = delta / 3600000L;
            return hours + ONE_HOUR_AGO;
        }
        if (delta < 172800000L) {
            return YESTERDAY;
        }
        if (delta < 604800000L) {
            long days = delta / 86400000L;
            return days + ONE_DAY_AGO;
        }
        if (delta < 2592000000L) {
            long days = delta / 604800000L;
            return days + ONE_WEEK_AGO;
        }
        if (delta < 29030400000L) {
            long months = delta / 2592000000L;
            return months + ONE_MONTH_AGO;
        }
        long years = delta / 31536000000L;
        return (years <= 0L ? 1L : years) + ONE_YEAR_AGO;
    }

    private static Calendar getMorningTime(Integer amount) {
        Calendar morningTime = Calendar.getInstance();
        morningTime.set(11, 0);
        morningTime.set(12, 0);
        morningTime.set(13, 0);
        morningTime.set(14, 0);
        morningTime.add(6, amount);
        return morningTime;
    }

    public static String getDayLag(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar now = Calendar.getInstance();
        if (now.get(5) == calendar.get(5)) {
            return "\u4eca\u5929";
        }
        if (calendar.after(now)) {
            now.add(5, 1);
            if (now.get(5) == calendar.get(5)) {
                return "\u660e\u5929";
            }
            now.add(5, 1);
            if (now.get(5) == calendar.get(5)) {
                return "\u540e\u5929";
            }
        } else {
            now.add(5, -1);
            if (now.get(5) == calendar.get(5)) {
                return YESTERDAY;
            }
            now.add(5, -1);
            if (now.get(5) == calendar.get(5)) {
                return "\u524d\u5929";
            }
        }
        return DateUtils.formatDate(date);
    }

    private DateBeautifyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

