package com.bxm.component.annotations;

import org.springframework.cloud.openfeign.FeignClient;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;

/**
 * Feign调用的目标服务版本
 * @author liujia
 * @date 2020/04/28 17:40
 */
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Target(TYPE)
@FeignClient
public @interface ServerVersion {
    /**
     * 服务版本号，如：1.0.0
     * @return 目标版本号
     */
    String value() default "";
}
