package com.bxm.newidea.component.util;

import com.bxm.newidea.component.config.PointInfoProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * 初始化工具类
 *
 * @author liujia
 * @date 6/9/21 1:52 PM
 **/
@Configuration
@Slf4j
@EnableConfigurationProperties(PointInfoProperties.class)
public class PointConfiguration implements ApplicationRunner {

    private PointInfoProperties pointInfoProperties;

    public PointConfiguration(PointInfoProperties pointInfoProperties) {
        this.pointInfoProperties = pointInfoProperties;
    }

    @Override
    public void run(ApplicationArguments args) {
        if (pointInfoProperties.getReportPointUrl() == null && pointInfoProperties.getProjectPointUrlMap() == null) {
            log.error("引入了打点组件，但是未提供打点上传地址：[component.dot.reportPointUrl]或[component.dot.projectPointUrlMap]");
        }

        if (pointInfoProperties.getProjectName() == null) {
            log.error("引入了打点组件，但是未提供打点对应的项目名称：[component.dot.projectName]。取值为数据平台对应的名称");
        }

        PointReportUtils.setPointInfoProperties(pointInfoProperties);
    }
}
