package com.bxm.newidea.component.util;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.config.PointInfoProperties;
import com.bxm.newidea.component.model.param.PointParam;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * 数据打点工具类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/6/8 2:15 下午
 */
@Slf4j
public class PointReportUtils {

    private static PointInfoProperties pointInfoProperties;

    private PointReportUtils() {

    }

    static void setPointInfoProperties(PointInfoProperties pointInfoProperties) {
        PointReportUtils.pointInfoProperties = pointInfoProperties;
    }

    /**
     * 上报数据埋点
     *
     * @param param 埋点参数
     */
    public static void report(PointParam param) {
        Map<String, String> data = param.getFinalData();
        try {
            String projectName = data.computeIfAbsent("p", k -> pointInfoProperties.getProjectName());

            String version = pointInfoProperties.getProjectVersionMap().get(projectName);
            if (null != version) {
                data.put("v", version);
            } else {
                data.computeIfAbsent("v", k -> pointInfoProperties.getReportPointVersion());
            }

            String url = pointInfoProperties.getProjectPointUrlMap().get(projectName);
            if (null == url) {
                url = pointInfoProperties.getReportPointUrl();
            }

            OkHttpUtils.getWithDefaultHeader(url, data);

            if (log.isDebugEnabled()) {
                log.debug("上报打点完成，日志参数：{}", JSON.toJSONString(data));
            }

        } catch (Exception e) {
            log.error("埋点上报失败，埋点内容：[{}]", JSON.toJSONString(data));
            log.error(e.getMessage(), e);
        }
    }
}