/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.util;

import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.config.ComponentPointInfoProperties;
import com.bxm.newidea.component.util.PointReportUtils;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportConsumer {
    private static final Logger log = LoggerFactory.getLogger(ReportConsumer.class);
    private ComponentPointInfoProperties pointInfoProperties;
    private Executor executor;

    public ReportConsumer(ComponentPointInfoProperties pointInfoProperties, Executor executor) {
        this.pointInfoProperties = pointInfoProperties;
        this.executor = executor;
        PointReportUtils.setReportConsumer(this);
    }

    void consume(Map<String, String> data) {
        try {
            this.executor.execute(() -> {
                String projectName = data.computeIfAbsent("p", k -> this.pointInfoProperties.getProjectName());
                String version = this.pointInfoProperties.getProjectVersionMap().get(projectName);
                if (null != version) {
                    data.put("v", version);
                } else {
                    data.computeIfAbsent("v", k -> this.pointInfoProperties.getReportPointVersion());
                }
                String url = this.pointInfoProperties.getProjectPointUrlMap().get(projectName);
                if (null == url) {
                    url = this.pointInfoProperties.getReportPointUrl();
                }
                String queryParam = HttpUtil.toParams((Map)data);
                String finalUrl = url;
                finalUrl = url.contains("?") ? finalUrl + "&" : finalUrl + "?";
                finalUrl = finalUrl + queryParam;
                HttpUtil.get((String)finalUrl, (int)1500);
                if (log.isDebugEnabled()) {
                    log.debug("\u4e0a\u62a5\u6570\u636e\u57cb\u70b9\u5b8c\u6210\uff0c\u65e5\u5fd7\u53c2\u6570\uff1a{}", (Object)finalUrl);
                }
            });
        }
        catch (Exception e) {
            log.error("\u57cb\u70b9\u4e0a\u62a5\u5931\u8d25\uff0c\u57cb\u70b9\u5185\u5bb9\uff1a[{}]", data);
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

