package com.bxm.newidea.component.emoji;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

/**
 * emoji 表情编码加载器
 *
 * @author stephen
 */
public class EmojiCodeLoader {

    /**
     * 加载emoji表情编码
     *
     * @param stream
     * @return
     * @throws IOException
     */
    public static Map<String, String> loadEmojis(InputStream stream) throws IOException {
        return JSON.parseObject(inputStreamToString(stream), new TypeReference<HashMap<String, String>>() {
        });
    }

    private static String inputStreamToString(
            InputStream stream
    ) throws IOException {
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(stream, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        String read;
        while ((read = br.readLine()) != null) {
            sb.append(read);
        }
        br.close();
        return sb.toString();
    }

}
