package com.bxm.newidea.component.emoji;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

/**
 * emoji表情编码管理器
 *
 * @author stephen
 */
public class EmojiCodeManager {
    private static final String PATH = "/emojicodes.json";
    private static final Map<String, String> EMOJI_CODE_MAP = new HashMap<>(1024);

    static {
        try (InputStream stream = EmojiCodeLoader.class.getResourceAsStream(PATH)) {
            EMOJI_CODE_MAP.putAll(EmojiCodeLoader.loadEmojis(stream));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 根据softbank编码获取unicode编码
     *
     * @param key
     * @return
     */
    public static String getEmojiCodeMapValue(String key) {
        return EMOJI_CODE_MAP.get(key);
    }
}

