package com.bxm.newidea.component.emoji;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * emoji表情转换器
 *
 * @author stephen
 */
public class EmojiCodeParser {
    private static final Pattern PATTERN = Pattern.compile("([\\uE000-\\uEFFF])");

    /**
     * 判断字符串是否包含softbank emoji
     *
     * @param str 待判断字符串
     * @return true：包含  false：不包含
     */
    public static boolean hasSoftbankEmoji(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }

        Matcher matcher = PATTERN.matcher(str);
        return matcher.find();
    }

    /**
     * 替换字符串内softbank编码为unicode编码
     *
     * @param str 需替换字符串
     * @return 替换后字符串
     */
    public static String replaceSoftbankEmoji(String str) {
        if (StringUtils.isBlank(str)) {
            return str;
        }

        Matcher matcher = PATTERN.matcher(str);
        Map<String, String> keyMap = new HashMap<>();
        //不需要每次匹配到都替换，先保存需替换的字符，再统一替换，可在重复较多时提升效率
        while (matcher.find()) {
            String key = matcher.group();
            String value = EmojiCodeManager.getEmojiCodeMapValue(key);
            if (StringUtils.isNotBlank(value)) {
                keyMap.put(key, value);
            }
        }

        //包含softbank emoji编码，需要替换
        if (keyMap.size() > 0) {
            for (Map.Entry<String, String> entry : keyMap.entrySet()) {
                str = str.replaceAll(entry.getKey(), entry.getValue());
            }
        }

        return str;
    }

}

