package com.huawei.push.samples;

import com.huawei.push.javasdk.exception.HuaweiMesssagingException;
import com.huawei.push.javasdk.message.*;
import com.huawei.push.javasdk.messaging.*;

public class HCMSamples {
    public HuaweiApp initializeApp() {
        // Create HuaweiCredential
        // This appId and appSecret come from Huawei Developer Alliance
        String appId = "YOUR_APPID";
        String appSecret = "YOUR_APPSECRET";
        HuaweiCredential credential = HuaweiCredential.builder()
                .setAppId(appId)
                .setAppSecret(appSecret)
                .build();

        // Create HuaweiOption
        HuaweiOption option = HuaweiOption.builder()
                .setCredential(credential)
                .build();

        // Initialize HuaweiApp
        return HuaweiApp.initializeApp(option);
    }

    public void sendToToken() throws HuaweiMesssagingException {
        // [START send_to_token]
        // Obtain initialized app
        HuaweiApp app = initializeApp();

        String token = "YOUR_TOKEN";
        // Define a message payload.
        Message message = Message.builder()
                .setData("the message to the client app")
                .addToken(token)
                .build();

        // Send a message to the device corresponding to the provided token
        SendResponse response = HuaweiMessaging.getInstance(app).send(message);
        // [END send_to_token]
    }

    public void sendToTopic() throws HuaweiMesssagingException {
        // [START send_to_topic]
        // Obtain initialized app
        HuaweiApp app = initializeApp();

        String topic = "YOUR_TOPIC";
        // Define a message payload.
        Message message = Message.builder()
                .setData("the message to the client app")
                .setTopic(topic)
                .build();

        // Send a message to the device corresponding to the provided topic
        SendResponse response = HuaweiMessaging.getInstance(app).send(message);
        // [END send_to_topic]
    }

    public void sendToCondition() throws HuaweiMesssagingException {
        // [START send_to_condition]
        // Obtain initialized app
        HuaweiApp app = initializeApp();

        String condition = "YOUR_CONDITION";
        // Define a message payload.
        Message message = Message.builder()
                .setData("the message to the client app")
                .setTopic(condition)
                .build();

        // Send a message to the device corresponding to the provided topic
        SendResponse response = HuaweiMessaging.getInstance(app).send(message);
        // [END send_to_condition]
    }

    public void sendValidateOnly() throws HuaweiMesssagingException {
        Message message = Message.builder()
                .setData("the message to the client app")
                .addToken("token")
                .build();

        HuaweiApp app = initializeApp();

        // [START send_validate_only]
        // Send a message not to the terminal
        boolean validateOnly = true;
        SendResponse response = HuaweiMessaging.getInstance(app).send(message, validateOnly);
        // [END send_validate_only]
    }

    public Message normalNotificationMessage() {
        String token = "YOUR_TOKEN";
        Notification notification = new Notification("Big News", "This is a Big News!");
        ClickAction clickAction = ClickAction.builder()
                .setType(1)
                .setIntent("#Intent;compo=com.rvr/.Activity;S.W=U;end")
                .build();
        BadgeNotification badgeNotification = new BadgeNotification(99, "Classic");
        AndroidNotification androidNotification = AndroidNotification.builder()
                .setTitle("Noti in Noti title")
                .setBody("Noti in Noti body")
                .setColor("#AACCDD")
                .setSound("/raw/shake")
                .setClickAction(clickAction)
                .setTitleLocKey("demo_title_new2")
                .addTitleLocArgs("title_args")
                .addTitleLocArgs("title_args2")
                .setBodyLocKey("demo_content_new2")
                .addBodyLocArgs("content_args")
                .addBodyLocArgs("content_args2")
                .setChannelId("RingRing")
                .setStyle(2)
                .setBigTitle("Big Boom Title")
                .setBigBody("Big BooBig Boom BodBig Boom BodBig Boom BodBig Boom BodBig Boom BodBig Boom BodBig Boom BodBig Boom BodBig Boom BodBig Boom Bodm Body")
                .setBigPicture("https://developer-portalres-drcn.dbankcdn.com/system/modules/org.opencms.portal.template.core/resources/images/icon_Promotion.png")
                .setAutoClear(86400000)
                .setNotifyId(486)
                .setBadge(badgeNotification)
                .build();

        AndroidConfig androidConfig = AndroidConfig.builder()
                .setCollapseKey(-1)
                .setTtl("1448s")
                .setBiTag("Trump")
                .setFastAppTargetType(1)
                .setNotification(androidNotification)
                .build();

        String data = "k=v,k=v";
        Message message = Message.builder()
                .setNotification(notification)
                .setAndroidConfig(androidConfig)
                .addToken(token)
                .build();

        return message;
    }

    public Message normalTransparentMessage() {
        String token = "YOUR_TOKEN";

        Message message = Message.builder()
                .setData("the message to the client app")
                .addToken(token)
                .build();
        return message;
    }
}
