/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.javasdk.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.push.javasdk.message.AndroidNotification;
import com.huawei.push.javasdk.message.Notification;
import com.huawei.push.javasdk.util.ValidatorUtils;
import org.apache.commons.lang3.StringUtils;

public class AndroidConfig {
    private static final String TTL_PATTERN = "\\d+|\\d+[sS]|\\d+.\\d{1,9}|\\d+.\\d{1,9}[sS]";
    @JsonProperty(value="collapse_key")
    private Integer collapseKey;
    @JsonProperty(value="ttl")
    private String ttl;
    @JsonProperty(value="bi_tag")
    private String biTag;
    @JsonProperty(value="fast_app_target")
    private Integer fastAppTargetType;
    @JsonProperty(value="notification")
    private AndroidNotification notification;

    public AndroidConfig(Builder builder) {
        this.collapseKey = builder.collapseKey;
        this.ttl = null != builder.ttl ? builder.ttl : null;
        this.biTag = builder.biTag;
        this.fastAppTargetType = builder.fastAppTargetType;
        this.notification = builder.notification;
    }

    public void check(Notification notification) {
        if (this.fastAppTargetType != null) {
            ValidatorUtils.checkArgument(this.fastAppTargetType == 1 || this.fastAppTargetType == 2, "Invalid fast app target type[one of 1 or 2]");
        }
        if (this.collapseKey != null) {
            ValidatorUtils.checkArgument(this.collapseKey >= -1 && this.collapseKey <= 100, "Collapse Key should be [-1, 100]");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.ttl)) {
            ValidatorUtils.checkArgument(this.ttl.matches(TTL_PATTERN), "The TTL's format is wrong");
        }
        if (null != this.notification) {
            this.notification.check(notification);
        }
    }

    public Integer getCollapseKey() {
        return this.collapseKey;
    }

    public String getTtl() {
        return this.ttl;
    }

    public String getBiTag() {
        return this.biTag;
    }

    public Integer getFastAppTargetType() {
        return this.fastAppTargetType;
    }

    public AndroidNotification getNotification() {
        return this.notification;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer collapseKey;
        private String ttl;
        private String biTag;
        private Integer fastAppTargetType;
        private AndroidNotification notification;

        private Builder() {
        }

        public Builder setCollapseKey(Integer collapseKey) {
            this.collapseKey = collapseKey;
            return this;
        }

        public Builder setTtl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder setBiTag(String biTag) {
            this.biTag = biTag;
            return this;
        }

        public Builder setFastAppTargetType(Integer fastAppTargetType) {
            this.fastAppTargetType = fastAppTargetType;
            return this;
        }

        public Builder setNotification(AndroidNotification notification) {
            this.notification = notification;
            return this;
        }

        public AndroidConfig build() {
            return new AndroidConfig(this);
        }
    }
}

