/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.javasdk.messaging;

import com.bxm.newidea.component.JSONObject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiCredential {
    private static final Logger logger = LoggerFactory.getLogger(HuaweiCredential.class);
    private final String PUSH_AT_URL = ResourceBundle.getBundle("url").getString("UP_URL");
    private String appId;
    private String appSecret;
    private String accessToken;
    private long expireIn;
    private Lock lock;
    private final CloseableHttpClient httpClient = HttpClients.createDefault();

    private HuaweiCredential(Builder builder) {
        this.lock = new ReentrantLock();
        this.appId = builder.appId;
        this.appSecret = builder.appSecret;
    }

    public final void refreshToken() {
        try {
            this.executeRefresh();
        }
        catch (IOException e) {
            logger.debug("Fail to refresh token!", (Throwable)e);
        }
    }

    private void executeRefresh() throws IOException {
        String requestBody = this.createRequestBody(this.appId, this.appSecret);
        HttpPost httpPost = new HttpPost(this.PUSH_AT_URL);
        StringEntity entity = new StringEntity(requestBody);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
        String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            this.accessToken = jsonObject.getString("access_token");
            this.expireIn = jsonObject.getLong("expires_in") * 1000L;
        } else {
            logger.debug("Fail to refresh token!");
        }
    }

    private String createRequestBody(String appId, String appSecret) {
        return MessageFormat.format("grant_type=client_credentials&client_secret={0}&client_id={1}", appSecret, appId);
    }

    public final String getAccessToken() {
        String tmp;
        this.lock.lock();
        try {
            tmp = this.accessToken;
        }
        finally {
            this.lock.unlock();
        }
        return tmp;
    }

    public final long getExpireIn() {
        long tmp;
        this.lock.lock();
        try {
            tmp = this.expireIn;
        }
        finally {
            this.lock.unlock();
        }
        return tmp;
    }

    protected CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getAppId() {
        return this.appId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String appId;
        private String appSecret;

        private Builder() {
        }

        public Builder setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder setAppSecret(String appSecret) {
            this.appSecret = appSecret;
            return this;
        }

        public HuaweiCredential build() {
            return new HuaweiCredential(this);
        }
    }
}

