package com.bxm.component.jwt.bo;

import io.jsonwebtoken.Header;

import java.util.Date;
import java.util.Map;

/**
 * @author liujia
 * @date 6/2/21 7:07 PM
 **/
public class JwtTokenBO {

    /**
     * 主体部分
     */
    private Map<String, Object> body;

    /**
     * 头部信息
     */
    private Header header;

    /**
     * 获取token的过期时间
     *
     * @return
     */
    public Date getExpirationDate() {
        if (null != body) {
            Integer expiredTime = (Integer) body.get("exp");
            if (null != expiredTime) {
                return new Date(expiredTime * 1000L);
            }
        }
        return null;
    }

    /**
     * 获取过期时间，单位为秒
     *
     * @return 过期到达时间（秒）
     */
    public Integer getExpirationSeconds() {
        if (null != body) {
            Integer expiredTime = (Integer) body.get("exp");
            if (null != expiredTime) {
                return expiredTime;
            }
        }
        return null;
    }

    /**
     * 获取body中的属性值，并且返回string类型
     *
     * @param key body中设置的属性
     * @return 键值对应的值
     */
    public String getBodyWithString(String key) {
        if (null != body && null != key) {
            Object value = body.get(key);
            if (null != value) {
                return value.toString();
            }
        }
        return null;
    }

    public Map<String, Object> getBody() {
        return body;
    }

    public void setBody(Map<String, Object> body) {
        this.body = body;
    }

    public Header getHeader() {
        return header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }
}
