/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.jwt.util;

import com.bxm.component.jwt.bo.JwtTokenBO;
import com.bxm.component.jwt.builder.TokenBuildParam;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtil {
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);

    private JwtUtil() {
    }

    public static String generateToken(TokenBuildParam buildParam) {
        return Jwts.builder().setHeader(buildParam.getHeaderMap()).setClaims(buildParam.getClaimMap()).setExpiration(buildParam.getExpirationTime()).setIssuedAt(buildParam.getIssueDate()).signWith(buildParam.getSignatureAlgorithm(), buildParam.getSignatureKey()).compact();
    }

    public static JwtTokenBO parseToken(String token, String signatureKey) {
        JwtTokenBO tokenBO = new JwtTokenBO();
        try {
            Jws jwt = Jwts.parser().setSigningKey(signatureKey).parseClaimsJws(token);
            Object body = jwt.getBody();
            if (body instanceof Claims) {
                tokenBO.setBody((Map<String, Object>)((Claims)body));
            }
            tokenBO.setHeader(jwt.getHeader());
        }
        catch (Exception e) {
            log.debug("token\u89e3\u6790\u9519\u8bef\uff0ctoken:{},\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{token, e.getMessage(), e});
        }
        return tokenBO;
    }
}

