package com.bxm;

import cn.hutool.core.util.RandomUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

@SuppressWarnings("AlibabaThreadPoolCreation")
@SpringBootApplication
@Slf4j
public class Application {
    public static void main(String[] args) {
        SpringApplication.run(Application.class, args);
        createLog();
    }

    public static void createLog() {
        ExecutorService executorService = Executors.newFixedThreadPool(10);

        for (int i = 0; i < 10; i++) {
            executorService.submit(() -> {
                while (true) {
                    int level = RandomUtil.randomInt();
                    if (level % 5 == 0) {
                        log.info("{}", level);
                    } else if (level % 4 == 0) {
                        log.debug("{}", level);
                    } else if (level % 3 == 0) {
                        log.error("{}", level);
                    } else if (level % 2 == 0) {
                        log.warn("{}", level);
                    }

                    TimeUnit.MILLISECONDS.sleep(50);
                }
            });
        }
    }
}
