package com.bxm.component.mircometer.config;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

import static com.bxm.component.mircometer.utils.TreadPoolMetrics.add;

/**
 * 线程池监控配置
 *
 * @author liujia
 * @date 12/2/21 1:14 PM
 **/
@Component
public class TreadPoolMetricsConfiguration implements MeterBinder {

    private ApplicationContext applicationContext;

    private ComponentMetricsProperties properties;

    public TreadPoolMetricsConfiguration(ApplicationContext applicationContext, ComponentMetricsProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        if (properties.isEnableThreadPool()) {
            Map<String, ThreadPoolExecutor> threadPoolExecutorMap = applicationContext.getBeansOfType(
                ThreadPoolExecutor.class);

            for (Map.Entry<String, ThreadPoolExecutor> executorEntry : threadPoolExecutorMap.entrySet()) {
                add(executorEntry.getKey(), executorEntry.getValue());
            }

            Map<String, ThreadPoolTaskExecutor> taskExecutorMap = applicationContext.getBeansOfType(
                ThreadPoolTaskExecutor.class);

            for (Map.Entry<String, ThreadPoolTaskExecutor> executorEntry : taskExecutorMap.entrySet()) {
                add(executorEntry.getKey(), executorEntry.getValue().getThreadPoolExecutor());
            }
        }
    }
}
