package com.bxm.component.mircometer.log4j2;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;

import java.io.Serializable;

/**
 * https://github.com/dropwizard/metrics/blob/v3.1.0/metrics-log4j2/src/main/java/log4j2/InstrumentedAppender.java
 *
 * @author liujia
 * @date 2022/07/20 17:45:33
 * @since 1.0.0
 */
public class InstrumentedAppender extends AbstractAppender {

    private static final String METER_NAME = "log4j2.event.count";

    private Counter trace;
    private Counter debug;
    private Counter info;
    private Counter warn;
    private Counter error;
    private Counter fatal;

    private MeterRegistry registry;

    /**
     * Create a new instrumented appender using the given registry.
     *
     * @param name             appender name
     * @param registry         the metric registry
     * @param filter           The Filter to associate with the Appender.
     * @param layout           The layout to use to format the event.
     * @param ignoreExceptions If true, exceptions will be logged and suppressed. If false errors will be
     *                         logged and then passed to the application.
     */
    public InstrumentedAppender(
        String name,
        MeterRegistry registry,
        Filter filter,
        Layout<? extends Serializable> layout,
        boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        this.registry = registry;
    }

    @Override
    public void start() {
        this.trace = Counter.builder(METER_NAME)
                            .tags("level", "trace")
                            .register(registry);

        this.debug = Counter.builder(METER_NAME)
                            .tags("level", "debug")
                            .register(registry);

        this.info = Counter.builder(METER_NAME)
                           .tags("level", "info")
                           .register(registry);

        this.warn = Counter.builder(METER_NAME)
                           .tags("level", "warn")
                           .register(registry);

        this.error = Counter.builder(METER_NAME)
                            .tags("level", "error")
                            .register(registry);

        this.fatal = Counter.builder(METER_NAME)
                            .tags("level", "fatal")
                            .register(registry);
        super.start();
    }

    @Override
    public void append(LogEvent event) {
        switch (event.getLevel().getStandardLevel()) {
            case TRACE:
                trace.increment();
                break;
            case DEBUG:
                debug.increment();
                break;
            case INFO:
                info.increment();
                break;
            case WARN:
                warn.increment();
                break;
            case ERROR:
                error.increment();
                break;
            case FATAL:
                fatal.increment();
                break;
            default:
                break;
        }
    }
}