package com.bxm.component.mircometer.log4j2;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import lombok.extern.slf4j.Slf4j;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.springframework.stereotype.Component;

/**
 * io.micrometer
 *
 * @author liujia
 * @date 2022/07/20 17:52:50
 * @since 1.0.0
 */
@Component
@Slf4j
public class Log4j2EventAppenderConfiguration implements MeterBinder {

    @Override
    public void bindTo(MeterRegistry registry) {
        log.info("[c-micrometer] 额外扩展log4j2监控配置");
        InstrumentedAppender appender = new InstrumentedAppender(
            "log4j2-micrometer-appender", registry, null, null, false
        );
        appender.start();

        LoggerContext context = (LoggerContext) LogManager.getContext(false);
        org.apache.logging.log4j.core.config.Configuration config = context.getConfiguration();
        config.getLoggerConfig(LogManager.ROOT_LOGGER_NAME).addAppender(appender, Level.ALL, null);
        context.updateLoggers(config);
    }
}
