package com.bxm.component.mybatis.dbshunt.param;

import com.bxm.component.mybatis.dbshunt.enums.DBShuntTypeEnum;
import lombok.Builder;
import lombok.Data;

/**
 * 操作数据分表入参
 *
 * @author lowi
 * @date 2021/6/28 18:15
 */
@Data
@Builder
public class ShuntParam {

    /**
     * 库的名称  ！！！必填
     */
    private String dataName;

    /**
     * 表的名称 ！！！必填
     */
    private String tableName;

    /**
     * ！！！必填
     * 类型 年 月  周 日
     * <p>
     * 年的话就是按年来分表
     * <p>
     * 月的话就是按月来分表
     * <p>
     * 周的话就是按周来分表
     * <p>
     * ！！！！！日的话就是按近多少日
     */
    private DBShuntTypeEnum dbShuntTypeEnum;

    /**
     * 按日配合使用，近多少天
     */
    private Integer typeValue;

    /**
     * 条件字段 默认为 create_time ,根据次字段作为分表判断依据
     */
    private String conditionField;
}
