package com.bxm.component.mybatis.dbshunt.strategy;

import com.bxm.component.mybatis.dbshunt.enums.DBShuntTypeEnum;
import com.bxm.component.mybatis.dbshunt.param.ShuntParam;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * 对数据表的一些操作
 *
 * @author lowi
 * @date 2021/6/28 16:47
 */
@Component
@Slf4j
public class TableHandlerProxy {


    private Map<DBShuntTypeEnum, TableHandler> handlerMap;

    @Autowired
    public TableHandlerProxy(List<TableHandler> handlerList) {
        handlerMap = Maps.newHashMap();

        if (!CollectionUtils.isEmpty(handlerList)) {
            handlerList.forEach(handler -> handlerMap.put(handler.getType(), handler));
        }
    }

    /**
     * 操作表数据
     *
     * @param shuntParam 入参
     */
    public void handleTableData(ShuntParam shuntParam) {

        TableHandler tableHandler = handlerMap.get(shuntParam.getDbShuntTypeEnum());

        if (tableHandler == null) {
            log.error("未知的分表策略，不做处理，shuntParam：{}", JSON.toJSONString(shuntParam));
            return;
        }
        shuntParam.setConditionField(StringUtils.isNotBlank(shuntParam.getConditionField()) ? shuntParam.getConditionField() : "create_time");
        handlerMap.get(shuntParam.getDbShuntTypeEnum()).tableDataHandler(shuntParam);
    }
}
