/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mybatis.utils;

import com.bxm.component.mybatis.utils.MapperRunner;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisBatchBuilder<M, E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MybatisBatchBuilder.class);
    private SqlSessionTemplate sqlSessionTemplate;
    private Class<M> mapperClass;
    private Collection<E> data;
    private int total = 0;
    private boolean strict = false;
    private int limit = 500;

    private MybatisBatchBuilder(Class<M> mapperClass, Collection<E> data) {
        this.mapperClass = mapperClass;
        this.data = data;
    }

    private MybatisBatchBuilder(Class<M> mapperClass, E[] data) {
        this.mapperClass = mapperClass;
        this.data = ImmutableList.copyOf((Object[])data).asList();
    }

    public static <M, E> MybatisBatchBuilder<M, E> create(Class<M> mapperClass, Collection<E> data) {
        return new MybatisBatchBuilder<M, E>(mapperClass, data);
    }

    public static <M, E> MybatisBatchBuilder<M, E> create(Class<M> mapperClass, E[] data) {
        return new MybatisBatchBuilder<M, E>(mapperClass, data);
    }

    public MybatisBatchBuilder<M, E> sessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSessionTemplate = sqlSessionTemplate;
        return this;
    }

    public MybatisBatchBuilder<M, E> sessionTemplateName(String sqlSessionTempalteName) {
        this.sqlSessionTemplate = (SqlSessionTemplate)SpringContextHolder.getBean((String)sqlSessionTempalteName);
        return this;
    }

    public MybatisBatchBuilder<M, E> strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public MybatisBatchBuilder<M, E> limit(int limit) {
        this.limit = limit;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(MapperRunner<M, E> runner) {
        if (this.sqlSessionTemplate == null) {
            this.sqlSessionTemplate = (SqlSessionTemplate)SpringContextHolder.getBean(SqlSessionTemplate.class);
        }
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH);
        Object mapper = session.getMapper(this.mapperClass);
        try {
            int i = 1;
            for (E element : this.data) {
                this.total += runner.run(mapper, element);
                if (i % this.limit == 0) {
                    session.commit();
                    session.clearCache();
                }
                ++i;
            }
        }
        catch (Exception e) {
            session.rollback();
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.data.size() % this.limit != 0) {
                session.commit();
                session.clearCache();
            }
            session.close();
        }
        if (this.strict) {
            return this.data != null && this.total == this.data.size();
        }
        return this.total != 0;
    }
}

