package com.bxm.component.mybatis.dbshunt.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.component.mybatis.dbshunt.entity.ShuntTableLog;
import org.apache.ibatis.annotations.*;

import java.util.List;
import java.util.Map;

/**
 * @author lowi
 * @date 2021/6/29 15:17
 */
@Mapper
public interface DBShuntMapper extends BaseMapper {

    /**
     * 获取表中最后一条信息
     *
     * @param dataName        库名
     * @param tableName       表名
     * @param dbShuntTypeEnum 类型
     * @return 信息
     */
    @Select("SELECT * FROM ${dataName} WHERE table_name = #{tableName} AND type = #{dbShuntTypeEnum}" +
            "  ORDER BY create_time DESC LIMIT 1"
    )
    ShuntTableLog getLastLogByTableNameAndType(@Param("dataName") String dataName
            , @Param("tableName") String tableName
            , @Param("dbShuntTypeEnum") Byte dbShuntTypeEnum);

    /**
     * 判断是否存在表
     *
     * @param dataName  库名
     * @param tableName 表名
     * @return 返回表名
     */
    @Select("select count(*)  " +
            "  from information_schema.TABLES  " +
            "   where LCASE(TABLE_SCHEMA) = #{dataName} AND LCASE(table_name) = #{tableName}")
    int isExistTable(@Param("dataName") String dataName, @Param("tableName") String tableName);

    /**
     * 模糊查询所有匹配到的表信息
     *
     * @param dataName  库名
     * @param tableName 表名
     * @return 返回表名
     */
    @Select("select TABLE_NAME  " +
            "  from information_schema.TABLES  " +
            "   where LCASE(TABLE_SCHEMA) = #{dataName} AND LCASE(table_name) LIKE concat(#{tableName},'%') ")
    List<String> isExistLikeTable(@Param("dataName") String dataName, @Param("tableName") String tableName);

    /**
     * 获取表字段信息
     *
     * @param dataName  库名
     * @param tableName 表名
     * @return 字段信息
     */
    @Select("select ORDINAL_POSITION,COlUMN_NAME,IS_NULLABLE,COLUMN_TYPE,COLUMN_KEY,CHARACTER_SET_NAME,COLUMN_COMMENT " +
            "from INFORMATION_SCHEMA.Columns where  TABLE_SCHEMA  = #{dataName}" +
            "  and table_name  = #{tableName}")
    List<Map<String, Object>> getTableFieldInfo(@Param("dataName") String dataName, @Param("tableName") String tableName);


    /**
     * 生成表信息
     */
    @Update("CREATE TABLE `t_db_shunt_table_log` (" +
            "  `id` bigint(20) NOT NULL COMMENT '主键'," +
            "  `table_name` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '表名'," +
            "  `type` int(11) NOT NULL COMMENT '类型 1：年 2：月 3 日'," +
            "  `type_value` int(11) COLLATE utf8_bin DEFAULT NULL COMMENT '类型为日 设置近几日数据'," +
            "  `suffix` varchar(20) COLLATE utf8_bin NOT NULL COMMENT '新表名的后缀'," +
            "  `create_time` datetime NOT NULL COMMENT '创建时间'," +
            "  PRIMARY KEY (`id`) ," +
            "  KEY `idx_table_type` (`table_name`,`type`) USING BTREE " +
            ") ENGINE=InnoDB  COMMENT='分表历史信息';")
    void initShuntTableData();

    /**
     * 根据时间条件是否存在数据
     *
     * @param oldTableName   原表名
     * @param conditionField 字段名
     * @param dateStr        时间
     * @return >0有数据
     */
    @Select("SELECT count(*) as num FROM ${oldTableName} WHERE ${conditionField} <= #{dateStr}")
    int isExistDataByDate(@Param("oldTableName") String oldTableName
            , @Param("conditionField") String conditionField
            , @Param("dateStr") String dateStr);

    /**
     * 根据时间条件是否存在数据
     *
     * @param newTableName   新表名
     * @param oldTableName   原表名
     * @param conditionField 字段名
     * @param dateStr        时间
     */
    @Insert("INSERT INTO ${newTableName} " +
            "   SELECT * FROM ${oldTableName} WHERE ${conditionField} <= #{dateStr} limit 5000")
    void insertDataToNewTable(@Param("newTableName") String newTableName
            , @Param("oldTableName") String oldTableName
            , @Param("conditionField") String conditionField
            , @Param("dateStr") String dateStr);

    /**
     * 根据时间条件删除原表数据
     *
     * @param oldTableName   原表名
     * @param conditionField 字段名
     * @param dateStr        时间
     */
    @Delete("DELETE FROM ${oldTableName} WHERE ${conditionField} <= #{dateStr} limit 5000")
    void deleteOldTableData(@Param("oldTableName") String oldTableName
            , @Param("conditionField") String conditionField
            , @Param("dateStr") String dateStr);

    /**
     * 插入新生成表信息
     *
     * @param logTableName  日志表的表名
     * @param shuntTableLog 要插入的信息
     */
    @Insert("INSERT INTO  ${logTableName} (`id`, `table_name`, `type`, `type_value`, `suffix`, `create_time`)" +
            " VALUES(#{logTable.id},#{logTable.tableName},#{logTable.type},#{logTable.typeValue},#{logTable.suffix},#{logTable.createTime})")
    void insertTableNameLog(@Param("logTableName") String logTableName, @Param("logTable") ShuntTableLog shuntTableLog);


}
