package com.bxm.component.mybatis.sharding;

import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;

/**
 * @author lowi
 * @date 2021/7/21 14:36
 */
public class NumberIdStrategy implements TableNameHandler {

    private Integer mod;

    /**
     * 使用ThreadLocal防止多线程相互影响
     */
    private static ThreadLocal<Long> primaryId = new ThreadLocal<Long>();

    /**
     * 设置表数据分了几个
     *
     * @param modValue 分表的个数
     */
    public NumberIdStrategy(Integer modValue) {
        this.mod = modValue;
    }

    /**
     * 使用分表查询，需要先一步设置查询的设备id，才能确定在哪个分表中
     *
     * @param idValue 设备id
     */
    public static void setPrimaryId(Long idValue) {
        primaryId.set(idValue);
    }


    @Override
    public String dynamicTableName(String sql, String tableName) {
        Long idValue = primaryId.get();

        if (idValue == null) {
            throw new RuntimeException("请设置id值");
        } else {
            String suffix = String.valueOf(idValue % mod);
            //这里清除ThreadLocal的值，防止线程复用出现问题
            primaryId.set(null);
            return tableName + "_" + suffix;
        }
    }

}
