/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mybatis.dbshunt.strategy;

import com.bxm.component.mybatis.dbshunt.enums.DBShuntTypeEnum;
import com.bxm.component.mybatis.dbshunt.param.ShuntParam;
import com.bxm.component.mybatis.dbshunt.strategy.TableHandler;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TableHandlerProxy {
    private static final Logger log = LoggerFactory.getLogger(TableHandlerProxy.class);
    private Map<DBShuntTypeEnum, TableHandler> handlerMap = Maps.newHashMap();

    @Autowired
    public TableHandlerProxy(List<TableHandler> handlerList) {
        if (!CollectionUtils.isEmpty(handlerList)) {
            handlerList.forEach(handler -> this.handlerMap.put(handler.getType(), (TableHandler)handler));
        }
    }

    public void handleTableData(ShuntParam shuntParam) {
        TableHandler tableHandler = this.handlerMap.get((Object)shuntParam.getDbShuntTypeEnum());
        if (tableHandler == null) {
            log.error("\u672a\u77e5\u7684\u5206\u8868\u7b56\u7565\uff0c\u4e0d\u505a\u5904\u7406\uff0cshuntParam\uff1a{}", (Object)JSON.toJSONString((Object)shuntParam));
            return;
        }
        shuntParam.setConditionField(StringUtils.isNotBlank((CharSequence)shuntParam.getConditionField()) ? shuntParam.getConditionField() : "create_time");
        this.handlerMap.get((Object)shuntParam.getDbShuntTypeEnum()).tableDataHandler(shuntParam);
    }
}

