/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mybatis.dbshunt.strategy.handle;

import com.bxm.component.mybatis.dbshunt.entity.ShuntTableLog;
import com.bxm.component.mybatis.dbshunt.enums.DBShuntTypeEnum;
import com.bxm.component.mybatis.dbshunt.mapper.DBShuntMapper;
import com.bxm.component.mybatis.dbshunt.param.ShuntParam;
import com.bxm.component.mybatis.dbshunt.strategy.TableHandler;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class AbstractTableHandler
implements TableHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractTableHandler.class);
    static final String TABLE_LOG_NAME = "t_db_shunt_table_log";
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    DBShuntMapper dbShuntMapper;

    void initShuntTableData(String dataName) {
        int existTable = this.dbShuntMapper.isExistTable(dataName, TABLE_LOG_NAME);
        if (existTable > 0) {
            return;
        }
        this.dbShuntMapper.initShuntTableData();
    }

    List<String> getTableNameList(String dataName, String tableName) {
        return this.dbShuntMapper.isExistLikeTable(dataName, tableName);
    }

    void initNewNameTable(String newTableName, ShuntParam shuntParam) {
        int existTable = this.dbShuntMapper.isExistTable(shuntParam.getDataName(), newTableName);
        if (existTable > 0) {
            return;
        }
        List<Map<String, Object>> tableFieldInfo = this.dbShuntMapper.getTableFieldInfo(shuntParam.getDataName(), shuntParam.getTableName());
        StringBuilder createTable = new StringBuilder();
        createTable.append("CREATE TABLE ").append(newTableName).append("(");
        String primaryKey = null;
        for (Map<String, Object> map : tableFieldInfo) {
            createTable.append(" `").append(map.get("COlUMN_NAME")).append("` ");
            createTable.append(" ").append(map.get("COLUMN_TYPE")).append(" ");
            if (Objects.nonNull(map.get("CHARACTER_SET_NAME")) && "utf8mb4".equals(map.get("CHARACTER_SET_NAME").toString().toLowerCase())) {
                createTable.append(" CHARACTER SET utf8mb4 ");
            }
            if (Objects.equals(map.get("IS_NULLABLE"), "YES")) {
                createTable.append(" DEFAULT NULL ");
            } else {
                createTable.append(" NOT NULL ");
            }
            if (Objects.nonNull(map.get("COLUMN_KEY").toString()) && "PRI".equals(map.get("COLUMN_KEY").toString())) {
                primaryKey = map.get("COlUMN_NAME").toString();
            }
            createTable.append(" COMMENT '").append(map.get("COLUMN_COMMENT")).append("', ");
        }
        if (primaryKey != null) {
            createTable.append(" PRIMARY KEY (`").append(primaryKey).append("`)");
            createTable.append(" )");
        } else {
            createTable.append(" )");
        }
        if (!tableFieldInfo.isEmpty()) {
            this.jdbcTemplate.update(createTable.toString());
        }
    }

    ShuntTableLog getLastLogByTableNameAndType(String tableName, DBShuntTypeEnum dbShuntTypeEnum) {
        return this.dbShuntMapper.getLastLogByTableNameAndType(TABLE_LOG_NAME, tableName, dbShuntTypeEnum.getType());
    }
}

