/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.listener;

import cn.hutool.core.collection.CollectionUtil;
import com.bxm.handler.NacosConfigChangeHandler;
import com.bxm.newidea.component.tools.StringUtils;
import com.purgeteam.dynamic.config.starter.annotation.EnableDynamicConfigEvent;
import com.purgeteam.dynamic.config.starter.event.ActionConfigEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@EnableDynamicConfigEvent
public class NacosConfigListener
implements ApplicationListener<ActionConfigEvent>,
ApplicationContextAware,
ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(NacosConfigListener.class);
    private Map<String, List<NacosConfigChangeHandler>> modifyConfigHandlerMap = new HashMap<String, List<NacosConfigChangeHandler>>();
    private static ApplicationContext applicationContext;
    private static Pattern linePattern;
    private static Pattern minusSignPattern;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        NacosConfigListener.applicationContext = applicationContext;
    }

    public void run(ApplicationArguments args) throws Exception {
        Collection handlers = applicationContext.getBeansOfType(NacosConfigChangeHandler.class).values();
        for (NacosConfigChangeHandler handler : handlers) {
            String listenerKey = handler.listenerConfigKey();
            if (StringUtils.isBlank((CharSequence)listenerKey)) {
                log.error("{} \u6ca1\u6709\u8bbe\u7f6e\u9700\u8981\u76d1\u542c\u7684Key\u503c\uff0c\u76d1\u542c\u65e0\u6548\uff0c\u8bf7\u914d\u7f6e", (Object)handler.getClass().getSimpleName());
                continue;
            }
            listenerKey = this.minusSignToHump(this.underlineToHump(listenerKey));
            List matchHandlerList = this.modifyConfigHandlerMap.getOrDefault(listenerKey, new ArrayList());
            matchHandlerList.add(handler);
            this.modifyConfigHandlerMap.put(listenerKey, matchHandlerList);
        }
    }

    public void onApplicationEvent(ActionConfigEvent event) {
        Map map = event.getPropertyMap();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String newKey = this.minusSignToHump(this.underlineToHump(key));
            ArrayList matchKey = new ArrayList();
            log.info("\u76d1\u542c\u5230nacos\u914d\u7f6e\u53d8\u66f4\uff0c\u53d8\u52a8\u7684key:{}", (Object)key);
            this.modifyConfigHandlerMap.forEach((beanConfigKey, bean) -> {
                if (newKey.startsWith((String)beanConfigKey)) {
                    matchKey.add(beanConfigKey);
                }
            });
            if (CollectionUtil.isEmpty(matchKey)) {
                return;
            }
            for (String listenerKey : matchKey) {
                List<NacosConfigChangeHandler> nacosConfigChangeHandler = this.modifyConfigHandlerMap.get(listenerKey);
                if (Objects.isNull(nacosConfigChangeHandler)) {
                    return;
                }
                if (Objects.isNull(entry.getValue())) {
                    for (NacosConfigChangeHandler configHandler : nacosConfigChangeHandler) {
                        configHandler.remove(key);
                    }
                    return;
                }
                Map changeMap = (Map)entry.getValue();
                log.info("\u914d\u7f6e[key:{}]\u88ab\u6539\u53d8\uff0c\u6539\u53d8\u524dbefore\uff1a{}\uff0c\u6539\u53d8\u540eafter\uff1a{}", new Object[]{key, changeMap.get("before"), changeMap.get("after")});
                if (!Objects.nonNull(changeMap.get("before")) || !Objects.nonNull(changeMap.get("after"))) continue;
                for (NacosConfigChangeHandler configHandler : nacosConfigChangeHandler) {
                    configHandler.change(key, changeMap.get("before"), changeMap.get("after"));
                }
                return;
            }
        }
    }

    public String underlineToHump(String str) {
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String minusSignToHump(String str) {
        Matcher matcher = minusSignPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static {
        linePattern = Pattern.compile("_(\\w)");
        minusSignPattern = Pattern.compile("-(\\w)");
    }
}

