package com.bxm.newidea.component.notify;


import com.bxm.newidea.component.notify.channel.ChannelAgent;
import com.bxm.newidea.component.notify.channel.IChannel;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.message.NotifyMessageBuilder;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.Executor;

/**
 * 消息发送门面 执行发送请求
 * 调用pushMessageDispatcher的分发方法
 *
 * @author JIY
 * @date 2021/11/23 17:52
 */
@Slf4j
@AllArgsConstructor
public class NotifyMessageSender {

    private Executor executor;

    private ChannelAgent channelAgent;

    /**
     * 发送通知消息
     * <p>
     * 参考{@link NotifyMessageBuilder}来进行构建
     * 也可以通过实现{@link NotifyMessage}来实现自定义的消息
     *
     * @param notifyMessage 通知消息
     */
    public <T extends NotifyMessage> void send(T notifyMessage) {
        for (IChannel channel : notifyMessage.getChannelList()) {
            executor.execute(() -> channelAgent.publish(channel, notifyMessage));
        }
    }
}
