package com.bxm.newidea.component.notify.assembly.dingding.model;

import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.google.common.collect.Lists;
import lombok.Data;

import java.util.List;

import static com.bxm.newidea.component.notify.constant.NotifyMessageConstant.Extend.AT_ALL;

@Data
public class AtSub {
    public boolean isAtAll;

    /// 用户ID没有获取渠道
    //public String[] atUserIds;

    public String[] atMobiles;

    public static AtSub get(NotifyMessage message) {
        AtSub atSub = new AtSub();

        if (message.getExtendMap() != null) {
            String atAll = message.getExtendMap().get(AT_ALL);
            if (null != atAll) {
                atSub.setAtAll(true);
            }
        }

        if (!atSub.isAtAll) {
            List<String> atMobileList = Lists.newArrayList();

            if (null != message.getMainReceiver()) {
                atMobileList.add(message.getMainReceiver());
            }
            if (null != message.getSubReceiver()) {
                atMobileList.addAll(message.getSubReceiver());
            }

            atSub.setAtMobiles(atMobileList.toArray(new String[]{}));
        }
        return atSub;
    }
}