package com.bxm.newidea.component.notify.assembly.wechat.model;

import lombok.Data;

import java.util.List;

/**
 * 微信card格式参数
 * <p>
 * {
 * "msgtype": "news",
 * "news": {
 * "articles" : [
 * {
 * "getTitle" : "中秋节礼品领取",
 * "description" : "今年中秋节公司有豪礼相送",
 * "url" : "www.qq.com",
 * "picurl" : "http://res.mail.qq.com/node/ww/wwopenmng/images/independent/doc/test_pic_msg1.png"
 * }
 * ]
 * }
 * }
 *
 * @author JIY
 * @date 2021/11/24 18:56
 */
@Data
public class WechatCardDTO {
    private String msgtype = "news";

    private News news;

    @Data
    public static class News {
        public List<Articles> articles;
    }

    @Data
    public static class Articles {
        public String title;

        private String description;

        public String url;

        public String picurl;

        public Articles(String title, String description, String url, String picurl) {
            this.title = title;
            this.description = description;
            this.url = url;
            this.picurl = picurl;
        }
    }
}
